/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.openmbean;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import org.quickfixj.jmx.openmbean.CompositeDataFactory;
import org.quickfixj.jmx.openmbean.CompositeTypeFactory;

public class CompositeDataBeanAdapter {
    private CompositeType compositeType;
    private final Class<?> beanClass;
    private final String defaultPropertyValue;

    public CompositeDataBeanAdapter(Class<?> beanClass) throws OpenDataException, IntrospectionException {
        this(beanClass, null);
    }

    public CompositeDataBeanAdapter(Class<?> beanClass, String defaultPropertyValue) throws IntrospectionException, OpenDataException {
        PropertyDescriptor[] propertyDescriptors;
        this.beanClass = beanClass;
        this.defaultPropertyValue = defaultPropertyValue;
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        CompositeTypeFactory typeFactory = new CompositeTypeFactory(beanDescriptor.getName(), beanDescriptor.getDisplayName());
        for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            if (!this.isExposed(pd)) continue;
            typeFactory.defineItem(pd.getDisplayName(), SimpleType.STRING);
        }
        this.compositeType = typeFactory.createCompositeType();
    }

    private boolean isExposed(PropertyDescriptor pd) {
        return !"class".equals(pd.getName()) && pd.getReadMethod() != null;
    }

    public CompositeData getData(Object bean) throws IntrospectionException, InvocationTargetException, OpenDataException, IllegalAccessException {
        PropertyDescriptor[] propertyDescriptors;
        CompositeDataFactory dataFactory = new CompositeDataFactory(this.compositeType);
        BeanInfo beanInfo = Introspector.getBeanInfo(this.beanClass);
        for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            if (!this.isExposed(pd)) continue;
            Object value = pd.getReadMethod().invoke(bean, (Object[])null);
            if (value == null && this.defaultPropertyValue != null) {
                value = this.defaultPropertyValue;
            }
            dataFactory.setValue(pd.getDisplayName(), value == null ? "" : value.toString());
        }
        return dataFactory.createCompositeData();
    }
}

