/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.quickfixj.jmx.mbean.connector.ConnectorJmxExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Connector;
import quickfix.mina.SessionConnector;

public class JmxExporter {
    public static final int REGISTRATION_FAIL_ON_EXISTING = 0;
    public static final int REGISTRATION_IGNORE_EXISTING = 1;
    public static final int REGISTRATION_REPLACE_EXISTING = 2;
    private int registrationBehaviour;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MBeanServer mbeanServer;
    private final ConnectorJmxExporter connectorExporter = new ConnectorJmxExporter();

    public JmxExporter(MBeanServer mbeanServer, int registrationBehaviour) {
        this.mbeanServer = mbeanServer;
        this.registrationBehaviour = registrationBehaviour;
    }

    public JmxExporter(MBeanServer mbeanServer) {
        this(mbeanServer, 0);
    }

    public JmxExporter() throws JMException {
        this(JmxExporter.createMBeanServer());
    }

    public void setRegistrationBehavior(int registrationBehaviour) {
        this.registrationBehaviour = registrationBehaviour;
    }

    private static MBeanServer createMBeanServer() throws JMException {
        try {
            Class<?> factoryClass = Class.forName("java.lang.management.ManagementFactory");
            try {
                return (MBeanServer)factoryClass.getMethod("getPlatformMBeanServer", new Class[0]).invoke(factoryClass, (Object[])null);
            }
            catch (Exception e) {
                JMException jme = new JMException(e.getMessage());
                jme.setStackTrace(e.getStackTrace());
                throw jme;
            }
        }
        catch (ClassNotFoundException e) {
            return MBeanServerFactory.createMBeanServer();
        }
    }

    public ObjectName register(Connector connector) {
        return this.connectorExporter.register(this, (SessionConnector)connector);
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void registerMBean(Object mbean, ObjectName objectName) throws JMException {
        try {
            this.mbeanServer.registerMBean(mbean, objectName);
        }
        catch (InstanceAlreadyExistsException ex) {
            if (this.registrationBehaviour == 1) {
                this.log.debug("Ignoring existing MBean at [{}]", (Object)objectName);
            }
            if (this.registrationBehaviour == 2) {
                try {
                    this.log.debug("Replacing existing MBean at [{}]", (Object)objectName);
                    this.mbeanServer.unregisterMBean(objectName);
                    this.mbeanServer.registerMBean(mbean, objectName);
                }
                catch (InstanceNotFoundException ex2) {
                    this.log.error("Unable to replace existing MBean at [" + objectName + "]", ex2);
                    throw ex;
                }
            }
            throw ex;
        }
    }
}

