/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai;

import java.util.HashMap;
import javax.swing.table.AbstractTableModel;
import quickfix.examples.banzai.Execution;

public class ExecutionTableModel
extends AbstractTableModel {
    private static final int SYMBOL = 0;
    private static final int QUANTITY = 1;
    private static final int SIDE = 2;
    private static final int PRICE = 3;
    private final HashMap<Integer, Execution> rowToExecution = new HashMap();
    private final HashMap<String, Integer> idToRow = new HashMap();
    private final HashMap<String, Execution> idToExecution = new HashMap();
    private final HashMap<String, Execution> exchangeIdToExecution = new HashMap();
    private final String[] headers = new String[]{"Symbol", "Quantity", "Side", "Price"};

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void addExecution(Execution execution) {
        int row = this.rowToExecution.size();
        if (this.exchangeIdToExecution.get(execution.getExchangeID()) != null) {
            return;
        }
        this.rowToExecution.put(row, execution);
        this.idToRow.put(execution.getID(), row);
        this.idToExecution.put(execution.getID(), execution);
        this.exchangeIdToExecution.put(execution.getExchangeID(), execution);
        this.fireTableRowsInserted(row, row);
    }

    public Execution getExchangeExecution(String exchangeID) {
        return this.exchangeIdToExecution.get(exchangeID);
    }

    public Execution getExecution(int row) {
        return this.rowToExecution.get(row);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    public Class<String> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.rowToExecution.size();
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.headers[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Execution execution = this.rowToExecution.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return execution.getSymbol();
            }
            case 1: {
                return execution.getQuantity();
            }
            case 2: {
                return execution.getSide();
            }
            case 3: {
                return execution.getPrice();
            }
        }
        return "";
    }
}

