/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.message;

import java.io.UnsupportedEncodingException;
import org.apache.mina.core.buffer.IoBuffer;
import org.quickfixj.CharsetSupport;

class PatternMatcher {
    private final byte[] pattern;
    private final int minLength;

    PatternMatcher(String pattern) {
        this.pattern = PatternMatcher.getBytes(pattern);
        this.minLength = this.calculateMinLength();
    }

    public int getMinLength() {
        return this.minLength;
    }

    private static byte[] getBytes(String s) {
        try {
            return s.getBytes(CharsetSupport.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private int calculateMinLength() {
        int len = 0;
        for (byte b : this.pattern) {
            if (b >= 97 && b <= 122) continue;
            ++len;
        }
        return len;
    }

    public long find(IoBuffer buffer, int offset) {
        byte first = this.pattern[0];
        int limit = buffer.limit() - this.minLength + 1;
        while (offset < limit) {
            int length;
            if (buffer.get(offset) == first && (length = this.match(buffer, offset)) > 0) {
                return (long)length << 32 | (long)offset;
            }
            ++offset;
        }
        return -1L;
    }

    public int match(IoBuffer buffer, int offset) {
        int patternOffset;
        if (offset + this.minLength > buffer.limit()) {
            return -1;
        }
        int startOffset = offset;
        int bufferLimit = buffer.limit();
        for (patternOffset = 0; patternOffset < this.pattern.length && offset < bufferLimit; ++patternOffset, ++offset) {
            byte b = this.pattern[patternOffset];
            if (buffer.get(offset) == b || b == 63) continue;
            if (b >= 97 && b <= 122) {
                if (b - 97 + 65 == buffer.get(offset)) continue;
                --offset;
                continue;
            }
            return -1;
        }
        if (patternOffset != this.pattern.length) {
            return -1;
        }
        return offset - startOffset;
    }
}

