/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import quickfix.examples.banzai.BanzaiApplication;
import quickfix.examples.banzai.Order;
import quickfix.examples.banzai.OrderTableModel;

public class OrderTable
extends JTable
implements MouseListener {
    private final transient BanzaiApplication application;

    public OrderTable(OrderTableModel orderTableModel, BanzaiApplication application) {
        super(orderTableModel);
        this.application = application;
        this.addMouseListener(this);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Order order = ((OrderTableModel)this.dataModel).getOrder(row);
        int open = order.getOpen();
        double executed = order.getExecuted();
        boolean rejected = order.getRejected();
        boolean canceled = order.getCanceled();
        DefaultTableCellRenderer r = (DefaultTableCellRenderer)renderer;
        r.setForeground(Color.black);
        if (rejected) {
            r.setBackground(Color.red);
        } else if (canceled) {
            r.setBackground(Color.white);
        } else if (open == 0 && executed == 0.0) {
            r.setBackground(Color.yellow);
        } else if (open > 0) {
            r.setBackground(Color.green);
        } else if (open == 0) {
            r.setBackground(Color.white);
        }
        return super.prepareRenderer(renderer, row, column);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        int row = this.rowAtPoint(e.getPoint());
        Order order = ((OrderTableModel)this.dataModel).getOrder(row);
        this.application.cancel(order);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

