/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.commons.compress.archivers.zip;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.python.apache.commons.compress.archivers.zip.StreamCompressor;
import org.python.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.python.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.python.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.python.apache.commons.compress.parallel.FileBasedScatterGatherBackingStore;
import org.python.apache.commons.compress.parallel.ScatterGatherBackingStore;
import org.python.apache.commons.compress.utils.BoundedInputStream;

public class ScatterZipOutputStream
implements Closeable {
    private final Queue<CompressedEntry> items = new ConcurrentLinkedQueue<CompressedEntry>();
    private final ScatterGatherBackingStore backingStore;
    private final StreamCompressor streamCompressor;

    public ScatterZipOutputStream(ScatterGatherBackingStore backingStore, StreamCompressor streamCompressor) {
        this.backingStore = backingStore;
        this.streamCompressor = streamCompressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArchiveEntry(ZipArchiveEntryRequest zipArchiveEntryRequest) throws IOException {
        InputStream payloadStream = zipArchiveEntryRequest.getPayloadStream();
        try {
            this.streamCompressor.deflate(payloadStream, zipArchiveEntryRequest.getMethod());
        }
        finally {
            payloadStream.close();
        }
        this.items.add(new CompressedEntry(zipArchiveEntryRequest, this.streamCompressor.getCrc32(), this.streamCompressor.getBytesWrittenForLastEntry(), this.streamCompressor.getBytesRead()));
    }

    public void writeTo(ZipArchiveOutputStream target) throws IOException {
        this.backingStore.closeForWriting();
        InputStream data = this.backingStore.getInputStream();
        for (CompressedEntry compressedEntry : this.items) {
            BoundedInputStream rawStream = new BoundedInputStream(data, compressedEntry.compressedSize);
            target.addRawArchiveEntry(compressedEntry.transferToArchiveEntry(), rawStream);
            rawStream.close();
        }
        data.close();
    }

    public void close() throws IOException {
        this.backingStore.close();
    }

    public static ScatterZipOutputStream fileBased(File file) throws FileNotFoundException {
        return ScatterZipOutputStream.fileBased(file, -1);
    }

    public static ScatterZipOutputStream fileBased(File file, int compressionLevel) throws FileNotFoundException {
        FileBasedScatterGatherBackingStore bs = new FileBasedScatterGatherBackingStore(file);
        StreamCompressor sc = StreamCompressor.create(compressionLevel, bs);
        return new ScatterZipOutputStream(bs, sc);
    }

    private static class CompressedEntry {
        final ZipArchiveEntryRequest zipArchiveEntryRequest;
        final long crc;
        final long compressedSize;
        final long size;

        public CompressedEntry(ZipArchiveEntryRequest zipArchiveEntryRequest, long crc, long compressedSize, long size) {
            this.zipArchiveEntryRequest = zipArchiveEntryRequest;
            this.crc = crc;
            this.compressedSize = compressedSize;
            this.size = size;
        }

        public ZipArchiveEntry transferToArchiveEntry() {
            ZipArchiveEntry entry = this.zipArchiveEntryRequest.getZipArchiveEntry();
            entry.setCompressedSize(this.compressedSize);
            entry.setSize(this.size);
            entry.setCrc(this.crc);
            entry.setMethod(this.zipArchiveEntryRequest.getMethod());
            return entry;
        }
    }
}

