/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyProperty$PyExposer;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="property", doc="property(fget=None, fset=None, fdel=None, doc=None) -> property attribute\n\nfget is a function to be used for getting an attribute value, and likewise\nfset is a function for setting, and fdel a function for del'ing, an\nattribute.  Typical use is to define a managed attribute x:\nclass C(object):\n    def getx(self): return self._x\n    def setx(self, value): self._x = value\n    def delx(self): del self._x\n    x = property(getx, setx, delx, \"I'm the 'x' property.\")\n\nDecorators make defining new properties or modifying existing ones easy:\nclass C(object):\n    @property\n    def x(self): return self._x\n    @x.setter\n    def x(self, value): self._x = value\n    @x.deleter\n    def x(self): del self._x\n")
public class PyProperty
extends PyObject {
    public static final PyType TYPE;
    protected PyObject fget;
    protected PyObject fset;
    protected PyObject fdel;
    protected boolean docFromGetter;
    protected PyObject doc;

    public PyProperty() {
        this(TYPE);
    }

    public PyProperty(PyType subType) {
        super(subType);
    }

    @ExposedNew
    public void property___init__(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("property", args, keywords, new String[]{"fget", "fset", "fdel", "doc"}, 0);
        this.fget = ap.getPyObject(0, null);
        this.fget = this.fget == Py.None ? null : this.fget;
        this.fset = ap.getPyObject(1, null);
        this.fset = this.fset == Py.None ? null : this.fset;
        this.fdel = ap.getPyObject(2, null);
        this.fdel = this.fdel == Py.None ? null : this.fdel;
        this.doc = ap.getPyObject(3, null);
        if ((this.doc == null || this.doc == Py.None) && this.fget != null) {
            PyObject getDoc = this.fget.__findattr__("__doc__");
            if (this.getType() == TYPE) {
                this.doc = getDoc;
            } else {
                this.__setattr__("__doc__", getDoc);
            }
            this.docFromGetter = true;
        }
    }

    @Override
    public PyObject __call__(PyObject arg1, PyObject[] args, String[] keywords) {
        return this.fget.__call__(arg1);
    }

    @Override
    public PyObject __get__(PyObject obj, PyObject type) {
        return this.property___get__(obj, type);
    }

    final PyObject property___get__(PyObject obj, PyObject type) {
        if (obj == null || obj == Py.None) {
            return this;
        }
        if (this.fget == null) {
            throw Py.AttributeError("unreadable attribute");
        }
        return this.fget.__call__(obj);
    }

    @Override
    public void __set__(PyObject obj, PyObject value) {
        this.property___set__(obj, value);
    }

    final void property___set__(PyObject obj, PyObject value) {
        if (this.fset == null) {
            throw Py.AttributeError("can't set attribute");
        }
        this.fset.__call__(obj, value);
    }

    @Override
    public void __delete__(PyObject obj) {
        this.property___delete__(obj);
    }

    final void property___delete__(PyObject obj) {
        if (this.fdel == null) {
            throw Py.AttributeError("can't delete attribute");
        }
        this.fdel.__call__(obj);
    }

    public PyObject getter(PyObject getter) {
        return this.property_getter(getter);
    }

    final PyObject property_getter(PyObject getter) {
        return this.propertyCopy(getter, null, null);
    }

    public PyObject setter(PyObject setter) {
        return this.property_setter(setter);
    }

    final PyObject property_setter(PyObject setter) {
        return this.propertyCopy(null, setter, null);
    }

    public PyObject deleter(PyObject deleter) {
        return this.property_deleter(deleter);
    }

    final PyObject property_deleter(PyObject deleter) {
        return this.propertyCopy(null, null, deleter);
    }

    private PyObject propertyCopy(PyObject get, PyObject set, PyObject del) {
        if (get == null) {
            PyObject pyObject = get = this.fget != null ? this.fget : Py.None;
        }
        if (set == null) {
            PyObject pyObject = set = this.fset != null ? this.fset : Py.None;
        }
        if (del == null) {
            PyObject pyObject = del = this.fdel != null ? this.fdel : Py.None;
        }
        PyObject doc = this.docFromGetter ? Py.None : (this.doc != null ? this.doc : Py.None);
        return this.getType().__call__(get, set, del, doc);
    }

    static {
        PyType.addBuilder(PyProperty.class, new PyProperty$PyExposer());
        TYPE = PyType.fromClass(PyProperty.class);
    }
}

