/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.social;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.social.Social;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class SocialRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Social social = (Social)component;
        this.encodeMarkup(context, social);
        this.encodeScript(context, social);
    }

    private void encodeMarkup(FacesContext context, Social social) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = social.getClientId(context);
        String widgetVar = social.resolveWidgetVar();
        String styleClass = social.getTheme() + " " + StringUtils.defaultString((String)social.getStyleClass());
        writer.startElement("div", (UIComponent)social);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (social.getStyle() != null) {
            writer.writeAttribute("style", (Object)social.getStyle(), "style");
        }
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, Social social) throws IOException {
        boolean showCount;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        String clientId = social.getClientId(context);
        wb.initWithDomReady("ExtSocial", social.resolveWidgetVar(), clientId);
        wb.attr("showLabel", Boolean.valueOf(social.isShowLabel()));
        wb.attr("shareIn", social.getShareIn());
        if (StringUtils.isNotBlank((CharSequence)social.getUrl())) {
            wb.attr("url", social.getUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)social.getText())) {
            wb.attr("text", social.getText());
        }
        if (showCount = BooleanUtils.toBoolean((String)social.getShowCount())) {
            wb.attr("showCount", Boolean.valueOf(showCount));
        } else if (social.getShowCount().equalsIgnoreCase("inside")) {
            wb.attr("showCount", social.getShowCount());
        } else {
            wb.attr("showCount", Boolean.valueOf(showCount));
        }
        wb.append(",shares: [");
        String[] shares = StringUtils.split((String)social.getShares(), (char)',');
        for (int i = 0; i < shares.length; ++i) {
            if (i != 0) {
                wb.append(",");
            }
            String share = StringUtils.lowerCase((String)shares[i]);
            wb.append("{");
            this.addShareProperty(wb, "share", share);
            if (share.equalsIgnoreCase("twitter")) {
                wb.attr("via", social.getTwitterUsername());
                wb.attr("hashtags", social.getTwitterHashtags());
            }
            if (share.equalsIgnoreCase("email")) {
                wb.attr("to", social.getEmailTo());
            }
            if (share.equalsIgnoreCase("pinterest")) {
                wb.attr("media", social.getPinterestMedia());
            }
            wb.append("}");
        }
        wb.append("]");
        wb.append(",on: {");
        if (social.getOnclick() != null) {
            this.addCallback(wb, "click", "function(e)", social.getOnclick());
        }
        if (social.getOnmouseenter() != null) {
            this.addCallback(wb, "mouseenter", "function(e)", social.getOnmouseenter());
        }
        if (social.getOnmouseleave() != null) {
            this.addCallback(wb, "mouseleave", "function(e)", social.getOnmouseleave());
        }
        wb.append("}");
        this.encodeClientBehaviors(context, social);
        wb.finish();
    }

    private void addShareProperty(WidgetBuilder wb, String property, String value) throws IOException {
        if (value != null) {
            wb.append(property);
            wb.append(":\"");
            wb.append(ComponentUtils.escapeEcmaScriptText((String)value));
            wb.append("\"");
        }
    }

    public void addCallback(WidgetBuilder wb, String name, String signature, String callback) throws IOException {
        if (callback != null) {
            wb.append(name);
            wb.append(":");
            wb.append(signature);
            wb.append("{");
            wb.append(callback);
            wb.append("},");
        }
    }
}

