/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class ClassUtils {
    private ClassUtils() {
    }

    public static ClassLoader getClassLoader(Object obj) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetClassLoaderAction(obj));
        }
        return ClassUtils.getClassLoaderInternal(obj);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetClassLoaderAction(clazz));
        }
        return ClassUtils.getClassLoaderInternal(clazz);
    }

    private static ClassLoader getClassLoaderInternal(Object obj) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null && obj != null) {
            loader = obj.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = ClassUtils.class.getClassLoader();
        }
        return loader;
    }

    private static ClassLoader getClassLoaderInternal(Class<?> clazz) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null && clazz != null) {
            loader = clazz.getClassLoader();
        }
        if (loader == null) {
            loader = ClassUtils.class.getClassLoader();
        }
        return loader;
    }

    static class GetClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        private Object obj;
        private Class<?> clazz;

        private GetClassLoaderAction(Object obj) {
            this.obj = obj;
        }

        private GetClassLoaderAction(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            try {
                if (this.obj == null) {
                    return ClassUtils.getClassLoaderInternal(this.clazz);
                }
                return ClassUtils.getClassLoaderInternal(this.obj);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

