/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.timeline;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.primefaces.extensions.component.timeline.TimelineUpdater;
import org.primefaces.extensions.model.timeline.TimelineEvent;
import org.primefaces.extensions.model.timeline.TimelineGroup;
import org.primefaces.extensions.util.TimelineEventComparator;

public class TimelineModel
implements Serializable {
    private static final long serialVersionUID = 20130316L;
    private List<TimelineEvent> events = new ArrayList<TimelineEvent>();
    private List<TimelineGroup> groups;

    public TimelineModel() {
    }

    public TimelineModel(List<TimelineEvent> events) {
        if (events != null && !events.isEmpty()) {
            for (TimelineEvent event : events) {
                this.add(event);
            }
        }
    }

    public TimelineModel(List<TimelineEvent> events, List<TimelineGroup> groups) {
        this(events);
        this.groups = groups;
    }

    public void add(TimelineEvent event) {
        this.events.add(event);
    }

    public void addGroup(TimelineGroup group) {
        if (this.groups == null) {
            this.groups = new ArrayList<TimelineGroup>();
        }
        this.groups.add(group);
    }

    public void add(TimelineEvent event, TimelineUpdater timelineUpdater) {
        this.events.add(event);
        if (timelineUpdater != null) {
            timelineUpdater.add(event);
        }
    }

    public void addAll(Collection<TimelineEvent> events) {
        this.addAll(events, null);
    }

    public void addAllGroups(Collection<TimelineGroup> groups) {
        if (groups == null) {
            groups = new ArrayList<TimelineGroup>();
        }
        groups.addAll(groups);
    }

    public void addAll(Collection<TimelineEvent> events, TimelineUpdater timelineUpdater) {
        if (events != null && !events.isEmpty()) {
            for (TimelineEvent event : events) {
                this.add(event, timelineUpdater);
            }
        }
    }

    public void update(TimelineEvent event) {
        this.update(event, null);
    }

    public void update(TimelineEvent event, TimelineUpdater timelineUpdater) {
        int index = this.getIndex(event);
        if (index >= 0) {
            this.events.set(index, event);
            if (timelineUpdater != null) {
                timelineUpdater.update(event, index);
            }
        }
    }

    public void updateAll(Collection<TimelineEvent> events) {
        this.updateAll(events, null);
    }

    public void updateAll(Collection<TimelineEvent> events, TimelineUpdater timelineUpdater) {
        if (events != null && !events.isEmpty()) {
            for (TimelineEvent event : events) {
                this.update(event, timelineUpdater);
            }
        }
    }

    public void delete(TimelineEvent event) {
        this.delete(event, null);
    }

    public void delete(TimelineEvent event, TimelineUpdater timelineUpdater) {
        int index = this.getIndex(event);
        if (index >= 0) {
            this.events.remove(event);
            if (timelineUpdater != null) {
                timelineUpdater.delete(index);
            }
        }
    }

    public void deleteAll(Collection<TimelineEvent> events) {
        this.deleteAll(events, null);
    }

    public void deleteAll(Collection<TimelineEvent> events, TimelineUpdater timelineUpdater) {
        if (events != null && !events.isEmpty()) {
            for (TimelineEvent event : events) {
                this.delete(event, timelineUpdater);
            }
        }
    }

    public void select(TimelineEvent event, TimelineUpdater timelineUpdater) {
        int index = this.getIndex(event);
        if (timelineUpdater != null) {
            timelineUpdater.select(index);
        }
    }

    public void clear() {
        this.events.clear();
    }

    public void clear(TimelineUpdater timelineUpdater) {
        this.events.clear();
        if (timelineUpdater != null) {
            timelineUpdater.clear();
        }
    }

    public TreeSet<TimelineEvent> getOverlappedEvents(TimelineEvent event) {
        if (event == null) {
            return null;
        }
        ArrayList<TimelineEvent> overlappedEvents = null;
        for (TimelineEvent e : this.events) {
            if (e.equals(event) || event.getGroup() == null && e.getGroup() != null || event.getGroup() != null && !event.getGroup().equals(e.getGroup()) || !this.isOverlapping(event, e)) continue;
            if (overlappedEvents == null) {
                overlappedEvents = new ArrayList<TimelineEvent>();
            }
            overlappedEvents.add(e);
        }
        if (overlappedEvents == null) {
            return null;
        }
        TreeSet<TimelineEvent> orderedOverlappedEvents = new TreeSet<TimelineEvent>(new TimelineEventComparator());
        orderedOverlappedEvents.addAll(overlappedEvents);
        return orderedOverlappedEvents;
    }

    public TimelineEvent merge(TimelineEvent event, Collection<TimelineEvent> events) {
        return this.merge(event, events, null);
    }

    public TimelineEvent merge(TimelineEvent event, Collection<TimelineEvent> events, TimelineUpdater timelineUpdater) {
        if (event == null) {
            return null;
        }
        if (events == null || events.isEmpty()) {
            return event;
        }
        String group = event.getGroup();
        for (TimelineEvent e : events) {
            if ((group != null || e.getGroup() == null) && (group == null || group.equals(e.getGroup()))) continue;
            throw new IllegalStateException("Events to be merged may be only belong to one and the same group!");
        }
        TreeSet<TimelineEvent> orderedEvents = new TreeSet<TimelineEvent>(new TimelineEventComparator());
        orderedEvents.add(event);
        orderedEvents.addAll(events);
        Date endDate = null;
        for (TimelineEvent e : orderedEvents) {
            if (endDate == null && e.getEndDate() != null) {
                endDate = e.getEndDate();
                continue;
            }
            if (endDate == null || e.getEndDate() == null || !endDate.before(e.getEndDate())) continue;
            endDate = e.getEndDate();
        }
        TimelineEvent mergedEvent = new TimelineEvent(event.getData(), orderedEvents.first().getStartDate(), endDate, event.isEditable(), event.getGroup(), event.getStyleClass());
        this.deleteAll(events, timelineUpdater);
        this.update(mergedEvent, timelineUpdater);
        return mergedEvent;
    }

    public List<TimelineEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<TimelineEvent> events) {
        this.events = events;
    }

    public List<TimelineGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<TimelineGroup> groups) {
        this.groups = groups;
    }

    public TimelineEvent getEvent(String index) {
        return this.getEvent(index != null ? Integer.valueOf(index) : -1);
    }

    public TimelineEvent getEvent(int index) {
        if (index < 0) {
            return null;
        }
        return this.events.get(index);
    }

    public int getIndex(TimelineEvent event) {
        int index = -1;
        if (event != null) {
            for (int i = 0; i < this.events.size(); ++i) {
                if (!this.events.get(i).equals(event)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    private boolean isOverlapping(TimelineEvent event1, TimelineEvent event2) {
        if (event1.getEndDate() == null && event2.getEndDate() == null) {
            return event1.getStartDate().equals(event2.getStartDate());
        }
        if (event1.getEndDate() == null && event2.getEndDate() != null) {
            return event1.getStartDate().equals(event2.getStartDate()) || event1.getStartDate().equals(event2.getEndDate()) || event1.getStartDate().after(event2.getStartDate()) && event1.getStartDate().before(event2.getEndDate());
        }
        if (event1.getEndDate() != null && event2.getEndDate() == null) {
            return event2.getStartDate().equals(event1.getStartDate()) || event2.getStartDate().equals(event1.getEndDate()) || event2.getStartDate().after(event1.getStartDate()) && event2.getStartDate().before(event1.getEndDate());
        }
        return event1.getStartDate().equals(event2.getStartDate()) || event1.getStartDate().equals(event2.getEndDate()) || event1.getStartDate().after(event2.getStartDate()) && event1.getStartDate().before(event2.getEndDate()) || event1.getEndDate().equals(event2.getStartDate()) || event1.getEndDate().equals(event2.getEndDate()) || event1.getEndDate().after(event2.getStartDate()) && event1.getEndDate().before(event2.getEndDate()) || event1.getStartDate().before(event2.getStartDate()) && event1.getEndDate().after(event2.getEndDate());
    }
}

