/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.dynaform;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.primefaces.extensions.model.common.KeyData;
import org.primefaces.extensions.model.dynaform.AbstractDynaFormElement;

public class DynaFormControl
extends AbstractDynaFormElement
implements KeyData {
    public static final String DEFAULT_TYPE = "default";
    private static final String KEY_PREFIX_ROW = "r";
    private static final String KEY_PREFIX_COLUMN = "c";
    private static final String KEY_SUFFIX_REGULAR = "reg";
    private static final String KEY_SUFFIX_EXTENDED = "ext";
    private String key;
    private Object data;
    private String type;

    public DynaFormControl(Object data, String type, int colspan, int rowspan, int row, int column, boolean extended) {
        super(colspan, rowspan, row, column, extended);
        this.data = data;
        this.type = type != null ? type : DEFAULT_TYPE;
        this.generateKey();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    public String getType() {
        return this.type;
    }

    void generateKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_PREFIX_ROW).append(this.getRow()).append(KEY_PREFIX_COLUMN).append(this.getColumn());
        if (this.isExtended()) {
            sb.append(KEY_SUFFIX_EXTENDED);
        } else {
            sb.append(KEY_SUFFIX_REGULAR);
        }
        this.setKey(sb.toString());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("key", (Object)this.key).append("data", this.data).append("type", (Object)this.type).append("colspan", this.getColspan()).append("rowspan", this.getRowspan()).append("row", this.getRow()).append("column", this.getColumn()).append("extended", this.isExtended()).toString();
    }
}

