/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.behavior.javascript;

import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.context.FacesContext;

@ResourceDependencies(value={@ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js")})
public class JavascriptBehavior
extends ClientBehaviorBase {
    public static final String BEHAVIOR_ID = "org.primefaces.extensions.behavior.JavascriptBehavior";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.behavior.JavascriptBehaviorRenderer";
    private Map<String, ValueExpression> bindings;
    private String execute;
    private boolean disabled = false;

    public String getRendererType() {
        return DEFAULT_RENDERER;
    }

    public final String getExecute() {
        return (String)this.eval("execute", this.execute);
    }

    public void setExecute(String execute) {
        this.execute = execute;
        this.clearInitialState();
    }

    public boolean isDisabled() {
        Boolean result = (Boolean)this.eval("disabled", this.disabled);
        return result != null ? result : false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.clearInitialState();
    }

    protected Object eval(String propertyName, Object value) {
        if (value != null) {
            return value;
        }
        ValueExpression expression = this.getValueExpression(propertyName);
        if (expression != null) {
            return expression.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return null;
    }

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.bindings == null ? null : this.bindings.get(name);
    }

    public void setValueExpression(String name, ValueExpression expr) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (expr != null) {
            if (expr.isLiteralText()) {
                this.setLiteralValue(name, expr);
            } else {
                if (this.bindings == null) {
                    this.bindings = new HashMap<String, ValueExpression>(6, 1.0f);
                }
                this.bindings.put(name, expr);
            }
        } else if (this.bindings != null) {
            this.bindings.remove(name);
            if (this.bindings.isEmpty()) {
                this.bindings = null;
            }
        }
        this.clearInitialState();
    }

    private void setLiteralValue(String propertyName, ValueExpression expression) {
        ELContext context = FacesContext.getCurrentInstance().getELContext();
        try {
            Object value = expression.getValue(context);
            if ("disabled".equals(propertyName)) {
                this.disabled = (Boolean)value;
            } else if ("execute".equals(propertyName)) {
                this.execute = (String)value;
            }
        }
        catch (ELException eLException) {
            throw new FacesException((Throwable)eLException);
        }
    }

    public Object saveState(FacesContext context) {
        Object values;
        Object superState = super.saveState(context);
        if (this.initialStateMarked()) {
            values = superState == null ? null : new Object[]{superState};
        } else {
            values = new Object[13];
            values[0] = superState;
            values[1] = this.execute;
            values[2] = this.disabled;
            values[3] = this.saveBindings(context, this.bindings);
        }
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            super.restoreState(context, values[0]);
            if (values.length != 1) {
                this.execute = (String)values[1];
                this.disabled = (Boolean)values[2];
                this.bindings = this.restoreBindings(context, values[3]);
                this.clearInitialState();
            }
        }
    }

    private Object saveBindings(FacesContext context, Map<String, ValueExpression> bindings) {
        if (bindings == null) {
            return null;
        }
        Object[] values = new Object[2];
        values[0] = bindings.keySet().toArray(new String[bindings.size()]);
        Object[] bindingValues = bindings.values().toArray();
        for (int i = 0; i < bindingValues.length; ++i) {
            bindingValues[i] = UIComponentBase.saveAttachedState((FacesContext)context, (Object)bindingValues[i]);
        }
        values[1] = bindingValues;
        return values;
    }

    private Map<String, ValueExpression> restoreBindings(FacesContext context, Object state) {
        if (state == null) {
            return null;
        }
        Object[] values = (Object[])state;
        String[] names = (String[])values[0];
        Object[] states = (Object[])values[1];
        HashMap<String, ValueExpression> bindings = new HashMap<String, ValueExpression>(names.length);
        for (int i = 0; i < names.length; ++i) {
            bindings.put(names[i], (ValueExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)states[i]));
        }
        return bindings;
    }
}

