/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.testng;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.powermock.core.MockRepository;
import org.powermock.modules.testng.PowerMockObjectFactory;
import org.powermock.reflect.Whitebox;
import org.testng.IObjectFactory;
import org.testng.ITestContext;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.ObjectFactory;

public class PowerMockTestCase {
    private Object annotationEnabler;

    public PowerMockTestCase() {
        try {
            Class<?> annotationEnablerClass = Class.forName("org.powermock.api.extension.listener.AnnotationEnabler");
            this.annotationEnabler = Whitebox.newInstance(annotationEnablerClass);
        }
        catch (ClassNotFoundException e) {
            this.annotationEnabler = null;
        }
    }

    @BeforeMethod
    protected void beforePowerMockTestMethod() throws Exception {
        this.injectMocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod
    protected void afterPowerMockTestMethod() throws Exception {
        try {
            this.clearMockFields();
        }
        finally {
            MockRepository.clear();
        }
    }

    @ObjectFactory
    public IObjectFactory create(ITestContext context) {
        return new PowerMockObjectFactory();
    }

    private void clearMockFields() throws Exception, IllegalAccessException {
        if (this.annotationEnabler != null) {
            Class[] mockAnnotations = (Class[])Whitebox.invokeMethod((Object)this.annotationEnabler, (String)"getMockAnnotations", (Object[])new Object[0]);
            Set mockFields = Whitebox.getFieldsAnnotatedWith((Object)this, (Class[])mockAnnotations);
            for (Field field : mockFields) {
                field.set(this, null);
            }
        }
    }

    private void injectMocks() throws Exception {
        if (this.annotationEnabler != null) {
            Whitebox.invokeMethod((Object)this.annotationEnabler, (String)"beforeTestMethod", (Class[])new Class[]{Object.class, Method.class, Object[].class}, (Object[])new Object[]{this, null, null});
        }
    }
}

