/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.repackaged.cglib.transform;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.powermock.api.mockito.repackaged.asm.Attribute;
import org.powermock.api.mockito.repackaged.asm.ClassReader;
import org.powermock.api.mockito.repackaged.asm.ClassWriter;
import org.powermock.api.mockito.repackaged.cglib.core.ClassGenerator;
import org.powermock.api.mockito.repackaged.cglib.core.CodeGenerationException;
import org.powermock.api.mockito.repackaged.cglib.core.DebuggingClassWriter;
import org.powermock.api.mockito.repackaged.cglib.transform.ClassFilter;
import org.powermock.api.mockito.repackaged.cglib.transform.ClassReaderGenerator;

public abstract class AbstractClassLoader
extends ClassLoader {
    private static ProtectionDomain DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return AbstractClassLoader.class.getProtectionDomain();
        }
    });
    private ClassFilter filter;
    private ClassLoader classPath;

    protected AbstractClassLoader(ClassLoader parent, ClassLoader classPath, ClassFilter filter) {
        super(parent);
        this.filter = filter;
        this.classPath = classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name) throws ClassNotFoundException {
        ClassReader r;
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded != null && loaded.getClassLoader() == this) {
            return loaded;
        }
        if (!this.filter.accept(name)) {
            return super.loadClass(name);
        }
        try {
            InputStream is = this.classPath.getResourceAsStream(name.replace('.', '/') + ".class");
            if (is == null) {
                throw new ClassNotFoundException(name);
            }
            try {
                r = new ClassReader(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name + ":" + e.getMessage());
        }
        try {
            DebuggingClassWriter w = new DebuggingClassWriter(1);
            this.getGenerator(r).generateClass(w);
            byte[] b = ((ClassWriter)w).toByteArray();
            Class<?> c = super.defineClass(name, b, 0, b.length, DOMAIN);
            this.postProcess(c);
            return c;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    protected ClassGenerator getGenerator(ClassReader r) {
        return new ClassReaderGenerator(r, this.attributes(), this.getFlags());
    }

    protected int getFlags() {
        return 0;
    }

    protected Attribute[] attributes() {
        return null;
    }

    protected void postProcess(Class c) {
    }
}

