/*
 *  Copyright (c) 2007 Mockito contributors
 *  This program is made available under the terms of the MIT License.
 */
package org.powermock.api.mockito.repackaged.cglib.core;

/**
 * Customize the generated class name for {@link AbstractClassGenerator}-based utilities.
 */
public interface NamingPolicy {
    /**
     * Choose a name for a generated class.
     * @param prefix a dotted-name chosen by the generating class (possibly to put the generated class in a particular package)
     * @param source the fully-qualified class name of the generating class (for example "org.powermock.api.mockito.repackaged.cglib.Enhancer")
     * @param key A key object representing the state of the parameters; for caching to work properly, equal keys should result
     * in the same generated class name. The default policy incorporates {@code key.hashCode()} into the class name.
     * @param names a predicate that returns true if the given classname has already been used in the same ClassLoader.
     * @return the fully-qualified class name
     */
    String getClassName(String prefix, String source, Object key, Predicate names);

    /**
     * The {@code NamingPolicy} in use does not currently, but may
     * in the future, affect the caching of classes generated by {@link
     * AbstractClassGenerator}, so this is a reminder that you should
     * correctly implement {@code equals} and {@code hashCode}
     * to avoid generating too many classes.
     */
    boolean equals(Object o);
}
