/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.easymock;

public class EasyMockConfiguration {
    private static final EasyMockConfiguration INSTANCE = new EasyMockConfiguration();
    private boolean testSubjectSupported;
    private boolean reallyEasyMock;
    private boolean injectMocksSupported;

    private EasyMockConfiguration() {
        this.initTestSubjectSupported();
        this.initReallyEasyMock();
        this.initInjectMocksSupported();
    }

    public static EasyMockConfiguration getConfiguration() {
        return INSTANCE;
    }

    private void initTestSubjectSupported() {
        try {
            Class.forName("org.easymock.TestSubject");
            this.testSubjectSupported = true;
        }
        catch (ClassNotFoundException e) {
            this.testSubjectSupported = false;
        }
    }

    private void initReallyEasyMock() {
        try {
            Class.forName("org.easymock.EasyMockSupport");
            this.reallyEasyMock = true;
        }
        catch (ClassNotFoundException e) {
            this.reallyEasyMock = false;
        }
    }

    private void initInjectMocksSupported() {
        try {
            Class<?> clazz = Class.forName("org.easymock.EasyMockSupport");
            clazz.getDeclaredMethod("injectMocks", Object.class);
            this.injectMocksSupported = true;
        }
        catch (NoSuchMethodException e) {
            this.injectMocksSupported = false;
        }
        catch (ClassNotFoundException e) {
            this.injectMocksSupported = false;
        }
    }

    public boolean isInjectMocksSupported() {
        return this.injectMocksSupported;
    }

    public boolean isReallyEasyMock() {
        return this.reallyEasyMock;
    }

    public boolean isTestSubjectSupported() {
        return this.testSubjectSupported;
    }
}

