/*
 * Decompiled with CFR 0.152.
 */
package org.pixsee.fcm;

import com.google.gson.JsonObject;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.logging.HttpLoggingInterceptor;
import org.pixsee.fcm.Message;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.POST;

public class Sender {
    private final String serverKey;
    private Interceptor interceptor;
    private OkHttpClient httpClient;
    private Retrofit retrofit;
    private HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();

    public Sender(String serverKey) {
        this.serverKey = serverKey;
        this.interceptor = this.createInterceptor();
        this.httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
        this.httpClient = new OkHttpClient.Builder().addInterceptor(this.interceptor).addInterceptor((Interceptor)this.httpLoggingInterceptor).build();
        this.retrofit = this.createRetrofit().build();
    }

    private Retrofit.Builder createRetrofit() {
        return this.createRetrofit((Converter.Factory)GsonConverterFactory.create());
    }

    private Retrofit.Builder createRetrofit(Converter.Factory factory) {
        return new Retrofit.Builder().baseUrl("https://fcm.googleapis.com/fcm/").client(this.httpClient).addConverterFactory(factory);
    }

    public void setLoggingLevel(HttpLoggingInterceptor.Level level) {
        this.httpLoggingInterceptor.setLevel(level);
    }

    private Interceptor createInterceptor() {
        return chain -> {
            Request request = chain.request().newBuilder().header("Authorization", String.format("key=%s", this.serverKey)).header("content-type", "application/json").build();
            return chain.proceed(request);
        };
    }

    public void send(Message message) {
        this.send(message, new EmptyCallback());
    }

    public void send(Message message, Callback callback) {
        ((GoogleCSS)this.retrofit.create(GoogleCSS.class)).send(message).enqueue(callback);
    }

    private class EmptyCallback
    implements Callback {
        private EmptyCallback() {
        }

        public void onResponse(Call call, Response response) {
            System.out.println(response.body());
        }

        public void onFailure(Call call, Throwable t) {
            t.printStackTrace();
        }
    }

    private static interface GoogleCSS {
        @POST(value="send")
        public Call<JsonObject> send(@Body Message var1);
    }
}

