/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.dispatcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.zip.GZIPOutputStream;
import org.piwik.sdk.dispatcher.Packet;
import org.piwik.sdk.dispatcher.PacketSender;
import timber.log.Timber;

public class DefaultPacketSender
implements PacketSender {
    private static final String LOGGER_TAG = "PIWIK:DefaultPacketSender";
    private long mTimeout = 5000L;
    private boolean mGzip = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Packet packet) {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)packet.getTargetURL().openConnection();
            Timber.tag((String)LOGGER_TAG).v("Connection open to %s", new Object[]{urlConnection.getURL().toExternalForm()});
            urlConnection.setConnectTimeout((int)this.mTimeout);
            urlConnection.setReadTimeout((int)this.mTimeout);
            if (packet.getPostData() != null) {
                urlConnection.setDoOutput(true);
                urlConnection.setRequestProperty("Content-Type", "application/json");
                urlConnection.setRequestProperty("charset", "utf-8");
                String toPost = packet.getPostData().toString();
                if (this.mGzip) {
                    urlConnection.addRequestProperty("Content-Encoding", "gzip");
                    ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
                    try (GZIPOutputStream gzipStream = null;){
                        gzipStream = new GZIPOutputStream(byteArrayOS);
                        gzipStream.write(toPost.getBytes(Charset.forName("UTF8")));
                    }
                    OutputStream outputStream = null;
                    try {
                        outputStream = urlConnection.getOutputStream();
                        outputStream.write(byteArrayOS.toByteArray());
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException e) {
                                Timber.tag((String)LOGGER_TAG).d((Throwable)e, "Failed to close output stream after writing gzipped POST data.", new Object[0]);
                            }
                        }
                    }
                }
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8"));
                    writer.write(toPost);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            Timber.tag((String)LOGGER_TAG).d((Throwable)e, "Failed to close output stream after writing POST data.", new Object[0]);
                        }
                    }
                }
            }
            urlConnection.setDoOutput(false);
            int statusCode = urlConnection.getResponseCode();
            boolean successful = DefaultPacketSender.checkResponseCode(statusCode);
            if (successful) {
                Timber.tag((String)LOGGER_TAG).v("Transmission successful (code=%d).", new Object[]{statusCode});
                InputStream is = urlConnection.getInputStream();
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Timber.tag((String)LOGGER_TAG).d((Throwable)e, "Failed to close the error stream.", new Object[0]);
                    }
                }
            } else {
                StringBuilder errorReason = new StringBuilder();
                BufferedReader errorReader = null;
                try {
                    String line;
                    errorReader = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
                    while ((line = errorReader.readLine()) != null) {
                        errorReason.append(line);
                    }
                }
                finally {
                    if (errorReader != null) {
                        try {
                            errorReader.close();
                        }
                        catch (IOException e) {
                            Timber.tag((String)LOGGER_TAG).d((Throwable)e, "Failed to close the error stream.", new Object[0]);
                        }
                    }
                }
                Timber.tag((String)LOGGER_TAG).w("Transmission failed (code=%d, reason=%s)", new Object[]{statusCode, errorReason.toString()});
            }
            boolean bl = successful;
            return bl;
        }
        catch (Exception e) {
            Timber.tag((String)LOGGER_TAG).e((Throwable)e, "Transmission failed unexpectedly.", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    @Override
    public void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    @Override
    public void setGzipData(boolean gzip) {
        this.mGzip = gzip;
    }

    public static boolean checkResponseCode(int code) {
        return code == 204 || code == 200;
    }
}

