/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.dispatcher;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.piwik.sdk.dispatcher.Event;
import org.piwik.sdk.dispatcher.Packet;
import timber.log.Timber;

public class PacketFactory {
    private static final String LOGGER_TAG = "PIWIK:PacketFactory";
    @VisibleForTesting
    public static final int PAGE_SIZE = 20;
    private final URL mApiUrl;

    public PacketFactory(@NonNull URL apiUrl) {
        this.mApiUrl = apiUrl;
    }

    @NonNull
    public List<Packet> buildPackets(@NonNull List<Event> events) {
        if (events.isEmpty()) {
            return Collections.emptyList();
        }
        if (events.size() == 1) {
            Packet p = this.buildPacketForGet(events.get(0));
            if (p == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(p);
        }
        int packets = (int)Math.ceil((double)events.size() * 1.0 / 20.0);
        ArrayList<Packet> freshPackets = new ArrayList<Packet>(packets);
        for (int i = 0; i < events.size(); i += 20) {
            List<Event> batch = events.subList(i, Math.min(i + 20, events.size()));
            Packet packet = batch.size() == 1 ? this.buildPacketForGet(batch.get(0)) : this.buildPacketForPost(batch);
            if (packet == null) continue;
            freshPackets.add(packet);
        }
        return freshPackets;
    }

    @Nullable
    private Packet buildPacketForPost(List<Event> events) {
        if (events.isEmpty()) {
            return null;
        }
        try {
            JSONObject params = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (Event event : events) {
                jsonArray.put((Object)event.getEncodedQuery());
            }
            params.put("requests", (Object)jsonArray);
            return new Packet(this.mApiUrl, params, events.size());
        }
        catch (JSONException e) {
            Timber.tag((String)LOGGER_TAG).w((Throwable)e, "Cannot create json object:\n%s", new Object[]{TextUtils.join((CharSequence)", ", events)});
            return null;
        }
    }

    @Nullable
    private Packet buildPacketForGet(@NonNull Event event) {
        if (event.getEncodedQuery().isEmpty()) {
            return null;
        }
        try {
            return new Packet(new URL(this.mApiUrl.toString() + event));
        }
        catch (MalformedURLException e) {
            Timber.tag((String)LOGGER_TAG).w((Throwable)e, null, new Object[0]);
            return null;
        }
    }
}

