/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.dispatcher;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.json.JSONObject;

public class Packet {
    private final URL mTargetURL;
    private final JSONObject mPostData;
    private final long mTimeStamp;
    private final int mEventCount;

    public Packet(@NonNull URL targetURL) {
        this(targetURL, null, 1);
    }

    public Packet(@NonNull URL targetURL, @Nullable JSONObject JSONObject2, int eventCount) {
        this.mTargetURL = targetURL;
        this.mPostData = JSONObject2;
        this.mEventCount = eventCount;
        this.mTimeStamp = System.currentTimeMillis();
    }

    @NonNull
    protected URL getTargetURL() {
        return this.mTargetURL;
    }

    @NonNull
    URLConnection openConnection() throws IOException {
        return this.mTargetURL.openConnection();
    }

    @Nullable
    public JSONObject getPostData() {
        return this.mPostData;
    }

    public long getTimeStamp() {
        return this.mTimeStamp;
    }

    public int getEventCount() {
        return this.mEventCount;
    }
}

