/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.dispatcher;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.piwik.sdk.TrackMe;
import org.piwik.sdk.dispatcher.DispatchMode;
import org.piwik.sdk.dispatcher.Event;
import org.piwik.sdk.dispatcher.EventCache;
import org.piwik.sdk.dispatcher.Packet;
import org.piwik.sdk.dispatcher.PacketFactory;
import org.piwik.sdk.tools.Connectivity;
import timber.log.Timber;

public class Dispatcher {
    private static final String LOGGER_TAG = "PIWIK:Dispatcher";
    private final Object mThreadControl = new Object();
    private final EventCache mEventCache;
    private final Semaphore mSleepToken = new Semaphore(0);
    private final Connectivity mConnectivity;
    private final PacketFactory mPacketFactory;
    static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private volatile int mTimeOut = 5000;
    static final long DEFAULT_DISPATCH_INTERVAL = 120000L;
    private volatile long mDispatchInterval = 120000L;
    private boolean mDispatchGzipped = false;
    private DispatchMode mDispatchMode = DispatchMode.ALWAYS;
    private volatile boolean mRunning = false;
    private List<Packet> mDryRunTarget = null;
    private Runnable mLoop = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (Dispatcher.this.mRunning) {
                try {
                    Dispatcher.this.mSleepToken.tryAcquire(Dispatcher.this.mDispatchInterval, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Timber.tag((String)Dispatcher.LOGGER_TAG).e((Throwable)e);
                }
                if (Dispatcher.this.mEventCache.updateState(Dispatcher.this.isConnected())) {
                    int count = 0;
                    ArrayList<Event> drainedEvents = new ArrayList<Event>();
                    Dispatcher.this.mEventCache.drainTo(drainedEvents);
                    Timber.tag((String)Dispatcher.LOGGER_TAG).d("Drained %s events.", new Object[]{drainedEvents.size()});
                    for (Packet packet : Dispatcher.this.mPacketFactory.buildPackets(drainedEvents)) {
                        boolean success = false;
                        try {
                            success = Dispatcher.this.dispatch(packet);
                        }
                        catch (IOException e) {
                            Timber.tag((String)Dispatcher.LOGGER_TAG).d((Throwable)e);
                        }
                        if (success) {
                            count += packet.getEventCount();
                            continue;
                        }
                        Timber.tag((String)Dispatcher.LOGGER_TAG).d("Unsuccesful assuming OFFLINE, requeuing events.", new Object[0]);
                        Dispatcher.this.mEventCache.updateState(false);
                        Dispatcher.this.mEventCache.requeue(drainedEvents.subList(count, drainedEvents.size()));
                        break;
                    }
                    Timber.tag((String)Dispatcher.LOGGER_TAG).d("Dispatched %d events.", new Object[]{count});
                }
                Object object = Dispatcher.this.mThreadControl;
                synchronized (object) {
                    if (Dispatcher.this.mEventCache.isEmpty() || Dispatcher.this.mDispatchInterval < 0L) {
                        Dispatcher.this.mRunning = false;
                        break;
                    }
                }
            }
        }
    };

    public Dispatcher(EventCache eventCache, Connectivity connectivity, PacketFactory packetFactory) {
        this.mConnectivity = connectivity;
        this.mEventCache = eventCache;
        this.mPacketFactory = packetFactory;
    }

    public int getConnectionTimeOut() {
        return this.mTimeOut;
    }

    public void setConnectionTimeOut(int timeOut) {
        this.mTimeOut = timeOut;
    }

    public void setDispatchInterval(long dispatchInterval) {
        this.mDispatchInterval = dispatchInterval;
        if (this.mDispatchInterval != -1L) {
            this.launch();
        }
    }

    public long getDispatchInterval() {
        return this.mDispatchInterval;
    }

    public void setDispatchGzipped(boolean dispatchGzipped) {
        this.mDispatchGzipped = dispatchGzipped;
    }

    public boolean getDispatchGzipped() {
        return this.mDispatchGzipped;
    }

    public void setDispatchMode(DispatchMode dispatchMode) {
        this.mDispatchMode = dispatchMode;
    }

    public DispatchMode getDispatchMode() {
        return this.mDispatchMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean launch() {
        Object object = this.mThreadControl;
        synchronized (object) {
            if (!this.mRunning) {
                this.mRunning = true;
                Thread thread = new Thread(this.mLoop);
                thread.setPriority(1);
                thread.start();
                return true;
            }
        }
        return false;
    }

    public boolean forceDispatch() {
        if (!this.launch()) {
            this.mSleepToken.release();
            return false;
        }
        return true;
    }

    public void clear() {
        this.mEventCache.clear();
        if (this.mRunning) {
            this.forceDispatch();
        }
    }

    public void submit(TrackMe trackMe) {
        this.mEventCache.add(new Event(trackMe.toMap()));
        if (this.mDispatchInterval != -1L) {
            this.launch();
        }
    }

    private boolean isConnected() {
        if (!this.mConnectivity.isConnected()) {
            return false;
        }
        switch (this.mDispatchMode) {
            case ALWAYS: {
                return true;
            }
            case WIFI_ONLY: {
                return this.mConnectivity.getType() == Connectivity.Type.WIFI;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public boolean dispatch(@NonNull Packet packet) throws IOException {
        if (this.mDryRunTarget != null) {
            this.mDryRunTarget.add(packet);
            Timber.tag((String)LOGGER_TAG).d("DryRun, stored HttpRequest, now %s.", new Object[]{this.mDryRunTarget.size()});
            return true;
        }
        HttpURLConnection urlConnection = null;
        try {
            block17: {
                block16: {
                    urlConnection = (HttpURLConnection)packet.openConnection();
                    urlConnection.setConnectTimeout(this.mTimeOut);
                    urlConnection.setReadTimeout(this.mTimeOut);
                    if (packet.getPostData() == null) break block16;
                    urlConnection.setDoOutput(true);
                    urlConnection.setRequestProperty("Content-Type", "application/json");
                    urlConnection.setRequestProperty("charset", "utf-8");
                    String toPost = packet.getPostData().toString();
                    if (this.mDispatchGzipped) {
                        urlConnection.addRequestProperty("Content-Encoding", "gzip");
                        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
                        try (GZIPOutputStream gzipStream = null;){
                            gzipStream = new GZIPOutputStream(byteArrayOS);
                            gzipStream.write(toPost.getBytes(Charset.forName("UTF8")));
                        }
                        urlConnection.getOutputStream().write(byteArrayOS.toByteArray());
                        break block17;
                    } else {
                        try (BufferedWriter writer = null;){
                            writer = new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8"));
                            writer.write(toPost);
                        }
                    }
                }
                urlConnection.setDoOutput(false);
            }
            int statusCode = urlConnection.getResponseCode();
            Timber.tag((String)LOGGER_TAG).d("status code %s", new Object[]{statusCode});
            boolean bl = this.checkResponseCode(statusCode);
            return bl;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    private boolean checkResponseCode(int code) {
        return code == 204 || code == 200;
    }

    public void setDryRunTarget(List<Packet> dryRunTarget) {
        this.mDryRunTarget = dryRunTarget;
    }

    public List<Packet> getDryRunTarget() {
        return this.mDryRunTarget;
    }
}

