/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.piwik.sdk.LegacySettingsPorter;
import org.piwik.sdk.Piwik;
import org.piwik.sdk.QueryParams;
import org.piwik.sdk.TrackMe;
import org.piwik.sdk.TrackerConfig;
import org.piwik.sdk.dispatcher.DispatchMode;
import org.piwik.sdk.dispatcher.Dispatcher;
import org.piwik.sdk.dispatcher.Packet;
import timber.log.Timber;

public class Tracker {
    private static final String LOGGER_TAG = "PIWIK:Tracker";
    private static final String DEFAULT_UNKNOWN_VALUE = "unknown";
    private static final String DEFAULT_TRUE_VALUE = "1";
    private static final String DEFAULT_RECORD_VALUE = "1";
    private static final String DEFAULT_API_VERSION_VALUE = "1";
    protected static final String PREF_KEY_TRACKER_OPTOUT = "tracker.optout";
    protected static final String PREF_KEY_TRACKER_USERID = "tracker.userid";
    protected static final String PREF_KEY_TRACKER_FIRSTVISIT = "tracker.firstvisit";
    protected static final String PREF_KEY_TRACKER_VISITCOUNT = "tracker.visitcount";
    protected static final String PREF_KEY_TRACKER_PREVIOUSVISIT = "tracker.previousvisit";
    protected static final String PREF_KEY_OFFLINE_CACHE_AGE = "tracker.cache.age";
    protected static final String PREF_KEY_OFFLINE_CACHE_SIZE = "tracker.cache.size";
    protected static final String PREF_KEY_DISPATCHER_MODE = "tracker.dispatcher.mode";
    private final Piwik mPiwik;
    private final URL mApiUrl;
    private final int mSiteId;
    private final Object mSessionLock = new Object();
    private final Dispatcher mDispatcher;
    private final String mName;
    private final Random mRandomAntiCachingValue = new Random(new Date().getTime());
    private final TrackMe mDefaultTrackMe = new TrackMe();
    private TrackMe mLastEvent;
    private String mApplicationDomain;
    private long mSessionTimeout = 1800000L;
    private long mSessionStartTime;
    private boolean mOptOut = false;
    private SharedPreferences mPreferences;
    private static final Pattern PATTERN_VISITOR_ID = Pattern.compile("^[0-9a-f]{16}$");
    private CountDownLatch mSessionStartLatch = new CountDownLatch(0);

    public Tracker(@NonNull Piwik piwik, @NonNull TrackerConfig trackerConfig) {
        this.mPiwik = piwik;
        this.mApiUrl = trackerConfig.getApiUrl();
        this.mSiteId = trackerConfig.getSiteId();
        this.mName = trackerConfig.getTrackerName();
        new LegacySettingsPorter(piwik).port(this);
        this.mOptOut = this.getPreferences().getBoolean(PREF_KEY_TRACKER_OPTOUT, false);
        this.mDispatcher = piwik.getDispatcherFactory().build(this);
        String userId = this.getPreferences().getString(PREF_KEY_TRACKER_USERID, null);
        if (userId == null) {
            userId = UUID.randomUUID().toString();
            this.getPreferences().edit().putString(PREF_KEY_TRACKER_USERID, userId).apply();
        }
        this.mDefaultTrackMe.set(QueryParams.USER_ID, userId);
        this.mDefaultTrackMe.set(QueryParams.SESSION_START, "1");
        String resolution = DEFAULT_UNKNOWN_VALUE;
        int[] res = this.mPiwik.getDeviceHelper().getResolution();
        if (res != null) {
            resolution = String.format("%sx%s", res[0], res[1]);
        }
        this.mDefaultTrackMe.set(QueryParams.SCREEN_RESOLUTION, resolution);
        this.mDefaultTrackMe.set(QueryParams.USER_AGENT, this.mPiwik.getDeviceHelper().getUserAgent());
        this.mDefaultTrackMe.set(QueryParams.LANGUAGE, this.mPiwik.getDeviceHelper().getUserLanguage());
        this.mDefaultTrackMe.set(QueryParams.VISITOR_ID, Tracker.makeRandomVisitorId());
        this.mDefaultTrackMe.set(QueryParams.URL_PATH, Tracker.fixUrl(null, this.getApplicationBaseURL()));
    }

    public void setOptOut(boolean optOut) {
        this.mOptOut = optOut;
        this.getPreferences().edit().putBoolean(PREF_KEY_TRACKER_OPTOUT, optOut).apply();
        this.mDispatcher.clear();
    }

    public boolean isOptOut() {
        return this.mOptOut;
    }

    public String getName() {
        return this.mName;
    }

    public Piwik getPiwik() {
        return this.mPiwik;
    }

    public URL getAPIUrl() {
        return this.mApiUrl;
    }

    protected int getSiteId() {
        return this.mSiteId;
    }

    public TrackMe getDefaultTrackMe() {
        return this.mDefaultTrackMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewSession() {
        Object object = this.mSessionLock;
        synchronized (object) {
            this.mSessionStartTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionTimeout(int milliseconds) {
        Object object = this.mSessionLock;
        synchronized (object) {
            this.mSessionTimeout = milliseconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryNewSession() {
        Object object = this.mSessionLock;
        synchronized (object) {
            boolean expired = System.currentTimeMillis() - this.mSessionStartTime > this.mSessionTimeout;
            this.mSessionStartTime = System.currentTimeMillis();
            return expired;
        }
    }

    public long getSessionTimeout() {
        return this.mSessionTimeout;
    }

    public int getDispatchTimeout() {
        return this.mDispatcher.getConnectionTimeOut();
    }

    public void setDispatchTimeout(int timeout) {
        this.mDispatcher.setConnectionTimeOut(timeout);
    }

    public void dispatch() {
        if (this.mOptOut) {
            return;
        }
        this.mDispatcher.forceDispatch();
    }

    public Tracker setDispatchInterval(long dispatchInterval) {
        this.mDispatcher.setDispatchInterval(dispatchInterval);
        return this;
    }

    public Tracker setDispatchGzipped(boolean dispatchGzipped) {
        this.mDispatcher.setDispatchGzipped(dispatchGzipped);
        return this;
    }

    public long getDispatchInterval() {
        return this.mDispatcher.getDispatchInterval();
    }

    public void setOfflineCacheAge(long age) {
        this.getPreferences().edit().putLong(PREF_KEY_OFFLINE_CACHE_AGE, age).apply();
    }

    public long getOfflineCacheAge() {
        return this.getPreferences().getLong(PREF_KEY_OFFLINE_CACHE_AGE, 86400000L);
    }

    public void setOfflineCacheSize(long size) {
        this.getPreferences().edit().putLong(PREF_KEY_OFFLINE_CACHE_SIZE, size).apply();
    }

    public long getOfflineCacheSize() {
        return this.getPreferences().getLong(PREF_KEY_OFFLINE_CACHE_SIZE, 0x400000L);
    }

    public DispatchMode getDispatchMode() {
        String raw = this.getPreferences().getString(PREF_KEY_DISPATCHER_MODE, null);
        DispatchMode mode = DispatchMode.fromString(raw);
        if (mode == null) {
            mode = DispatchMode.ALWAYS;
            this.setDispatchMode(mode);
        }
        return mode;
    }

    public void setDispatchMode(DispatchMode mode) {
        this.getPreferences().edit().putString(PREF_KEY_DISPATCHER_MODE, mode.toString()).apply();
        this.mDispatcher.setDispatchMode(mode);
    }

    public Tracker setUserId(String userId) {
        this.mDefaultTrackMe.set(QueryParams.USER_ID, userId);
        this.getPreferences().edit().putString(PREF_KEY_TRACKER_USERID, userId).apply();
        return this;
    }

    public String getUserId() {
        return this.mDefaultTrackMe.get(QueryParams.USER_ID);
    }

    public Tracker setVisitorId(String visitorId) throws IllegalArgumentException {
        if (this.confirmVisitorIdFormat(visitorId)) {
            this.mDefaultTrackMe.set(QueryParams.VISITOR_ID, visitorId);
        }
        return this;
    }

    public String getVisitorId() {
        return this.mDefaultTrackMe.get(QueryParams.VISITOR_ID);
    }

    private boolean confirmVisitorIdFormat(String visitorId) throws IllegalArgumentException {
        if (PATTERN_VISITOR_ID.matcher(visitorId).matches()) {
            return true;
        }
        throw new IllegalArgumentException("VisitorId: " + visitorId + " is not of valid format,  the format must match the regular expression: " + PATTERN_VISITOR_ID.pattern());
    }

    public Tracker setApplicationDomain(String domain) {
        this.mApplicationDomain = domain;
        this.mDefaultTrackMe.set(QueryParams.URL_PATH, Tracker.fixUrl(null, this.getApplicationBaseURL()));
        return this;
    }

    protected String getApplicationDomain() {
        return this.mApplicationDomain != null ? this.mApplicationDomain : this.mPiwik.getApplicationDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectInitialParams(TrackMe trackMe) {
        long previousVisit;
        long firstVisitTime;
        long visitCount;
        SharedPreferences sharedPreferences = this.getPreferences();
        synchronized (sharedPreferences) {
            visitCount = 1L + this.getPreferences().getLong(PREF_KEY_TRACKER_VISITCOUNT, 0L);
            this.getPreferences().edit().putLong(PREF_KEY_TRACKER_VISITCOUNT, visitCount).apply();
        }
        sharedPreferences = this.getPreferences();
        synchronized (sharedPreferences) {
            firstVisitTime = this.getPreferences().getLong(PREF_KEY_TRACKER_FIRSTVISIT, -1L);
            if (firstVisitTime == -1L) {
                firstVisitTime = System.currentTimeMillis() / 1000L;
                this.getPreferences().edit().putLong(PREF_KEY_TRACKER_FIRSTVISIT, firstVisitTime).apply();
            }
        }
        sharedPreferences = this.getPreferences();
        synchronized (sharedPreferences) {
            previousVisit = this.getPreferences().getLong(PREF_KEY_TRACKER_PREVIOUSVISIT, -1L);
            this.getPreferences().edit().putLong(PREF_KEY_TRACKER_PREVIOUSVISIT, System.currentTimeMillis() / 1000L).apply();
        }
        this.mDefaultTrackMe.trySet(QueryParams.FIRST_VISIT_TIMESTAMP, firstVisitTime);
        this.mDefaultTrackMe.trySet(QueryParams.TOTAL_NUMBER_OF_VISITS, visitCount);
        if (previousVisit != -1L) {
            this.mDefaultTrackMe.trySet(QueryParams.PREVIOUS_VISIT_TIMESTAMP, previousVisit);
        }
        trackMe.trySet(QueryParams.SESSION_START, this.mDefaultTrackMe.get(QueryParams.SESSION_START));
        trackMe.trySet(QueryParams.SCREEN_RESOLUTION, this.mDefaultTrackMe.get(QueryParams.SCREEN_RESOLUTION));
        trackMe.trySet(QueryParams.USER_AGENT, this.mDefaultTrackMe.get(QueryParams.USER_AGENT));
        trackMe.trySet(QueryParams.LANGUAGE, this.mDefaultTrackMe.get(QueryParams.LANGUAGE));
        trackMe.trySet(QueryParams.FIRST_VISIT_TIMESTAMP, this.mDefaultTrackMe.get(QueryParams.FIRST_VISIT_TIMESTAMP));
        trackMe.trySet(QueryParams.TOTAL_NUMBER_OF_VISITS, this.mDefaultTrackMe.get(QueryParams.TOTAL_NUMBER_OF_VISITS));
        trackMe.trySet(QueryParams.PREVIOUS_VISIT_TIMESTAMP, this.mDefaultTrackMe.get(QueryParams.PREVIOUS_VISIT_TIMESTAMP));
    }

    private void injectBaseParams(TrackMe trackMe) {
        trackMe.trySet(QueryParams.SITE_ID, this.mSiteId);
        trackMe.trySet(QueryParams.RECORD, "1");
        trackMe.trySet(QueryParams.API_VERSION, "1");
        trackMe.trySet(QueryParams.RANDOM_NUMBER, this.mRandomAntiCachingValue.nextInt(100000));
        trackMe.trySet(QueryParams.DATETIME_OF_REQUEST, new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ", Locale.US).format(new Date()));
        trackMe.trySet(QueryParams.SEND_IMAGE, "0");
        trackMe.trySet(QueryParams.VISITOR_ID, this.mDefaultTrackMe.get(QueryParams.VISITOR_ID));
        trackMe.trySet(QueryParams.USER_ID, this.mDefaultTrackMe.get(QueryParams.USER_ID));
        String urlPath = trackMe.get(QueryParams.URL_PATH);
        if (urlPath == null) {
            urlPath = this.mDefaultTrackMe.get(QueryParams.URL_PATH);
        } else {
            urlPath = Tracker.fixUrl(urlPath, this.getApplicationBaseURL());
            this.mDefaultTrackMe.set(QueryParams.URL_PATH, urlPath);
        }
        trackMe.set(QueryParams.URL_PATH, urlPath);
    }

    private static String fixUrl(String url, String baseUrl) {
        if (url == null) {
            url = baseUrl + "/";
        }
        if (!(url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://"))) {
            url = baseUrl + (url.startsWith("/") ? "" : "/") + url;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker track(TrackMe trackMe) {
        boolean newSession;
        Object object = this.mSessionLock;
        synchronized (object) {
            newSession = this.tryNewSession();
            if (newSession) {
                this.mSessionStartLatch = new CountDownLatch(1);
            }
        }
        if (newSession) {
            this.injectInitialParams(trackMe);
        } else {
            try {
                this.mSessionStartLatch.await(this.getDispatchTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Timber.tag((String)"ContentValues").e((Throwable)e, null, new Object[0]);
            }
        }
        this.injectBaseParams(trackMe);
        this.mLastEvent = trackMe;
        if (!this.mOptOut) {
            this.mDispatcher.submit(trackMe);
            Timber.tag((String)LOGGER_TAG).d("Event added to the queue: %s", new Object[]{trackMe});
        } else {
            Timber.tag((String)LOGGER_TAG).d("Event omitted due to opt out: %s", new Object[]{trackMe});
        }
        if (newSession) {
            this.mSessionStartLatch.countDown();
        }
        return this;
    }

    public static String makeRandomVisitorId() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 16);
    }

    public SharedPreferences getPreferences() {
        if (this.mPreferences == null) {
            this.mPreferences = this.mPiwik.getTrackerPreferences(this);
        }
        return this.mPreferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tracker tracker = (Tracker)o;
        if (this.mSiteId != tracker.mSiteId) {
            return false;
        }
        if (!this.mApiUrl.equals(tracker.mApiUrl)) {
            return false;
        }
        return this.mName.equals(tracker.mName);
    }

    public int hashCode() {
        int result = this.mApiUrl.hashCode();
        result = 31 * result + this.mSiteId;
        result = 31 * result + this.mName.hashCode();
        return result;
    }

    protected String getApplicationBaseURL() {
        return String.format("http://%s", this.getApplicationDomain());
    }

    @VisibleForTesting
    public TrackMe getLastEventX() {
        return this.mLastEvent;
    }

    public void setDryRunTarget(List<Packet> dryRunTarget) {
        this.mDispatcher.setDryRunTarget(dryRunTarget);
    }

    public List<Packet> getDryRunTarget() {
        return this.mDispatcher.getDryRunTarget();
    }
}

