/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.tools;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Method;
import java.util.Locale;
import timber.log.Timber;

public class DeviceHelper {
    private static final String LOGGER_TAG = "PIWIK:DeviceHelper";

    public static String getUserLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public static String getUserCountry() {
        return Locale.getDefault().getCountry();
    }

    public static String getUserAgent() {
        return System.getProperty("http.agent");
    }

    @TargetApi(value=17)
    public static int[] getResolution(Context context) {
        DisplayMetrics dm;
        Display display;
        int width = -1;
        int height = -1;
        try {
            WindowManager wm = (WindowManager)context.getSystemService("window");
            display = wm.getDefaultDisplay();
        }
        catch (NullPointerException e) {
            Timber.tag((String)LOGGER_TAG).e((Throwable)e, "Window service was not available from this context", new Object[0]);
            return null;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            dm = new DisplayMetrics();
            display.getRealMetrics(dm);
            width = dm.widthPixels;
            height = dm.heightPixels;
        } else if (Build.VERSION.SDK_INT >= 14) {
            try {
                Method getRawWidth = Display.class.getMethod("getRawWidth", new Class[0]);
                Method getRawHeight = Display.class.getMethod("getRawHeight", new Class[0]);
                width = (Integer)getRawWidth.invoke((Object)display, new Object[0]);
                height = (Integer)getRawHeight.invoke((Object)display, new Object[0]);
            }
            catch (Exception e) {
                Timber.tag((String)LOGGER_TAG).w((Throwable)e, "Reflection of getRawWidth/getRawHeight failed on API14-16 unexpectedly.", new Object[0]);
            }
        }
        if (width == -1 || height == -1) {
            dm = new DisplayMetrics();
            display.getMetrics(dm);
            width = dm.widthPixels;
            height = dm.heightPixels;
        }
        return new int[]{width, height};
    }
}

