/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.dispatcher;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.piwik.sdk.QueryParams;
import timber.log.Timber;

public class TrackerBulkURLWrapper {
    private static final String LOGGER_TAG = "PIWIK:TrackerBulkURLWrapper";
    private static final int EVENTS_PER_PAGE = 20;
    private int mCurrentPage = 0;
    private final int mPages;
    private final URL mApiUrl;
    private final String mAuthtoken;
    private final List<String> mEvents;

    public TrackerBulkURLWrapper(@NonNull URL apiUrl, @NonNull List<String> events, @Nullable String authToken) {
        this.mApiUrl = apiUrl;
        this.mAuthtoken = authToken;
        this.mPages = (int)Math.ceil((double)events.size() * 1.0 / 20.0);
        this.mEvents = events;
    }

    protected static int getEventsPerPage() {
        return 20;
    }

    public Iterator<Page> iterator() {
        return new Iterator<Page>(){

            @Override
            public boolean hasNext() {
                return TrackerBulkURLWrapper.this.mCurrentPage < TrackerBulkURLWrapper.this.mPages;
            }

            @Override
            public Page next() {
                if (this.hasNext()) {
                    return new Page(TrackerBulkURLWrapper.this.mCurrentPage++);
                }
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    @NonNull
    public URL getApiUrl() {
        return this.mApiUrl;
    }

    @Nullable
    public JSONObject getEvents(Page page) {
        if (page == null || page.isEmpty()) {
            return null;
        }
        List<String> pageElements = this.mEvents.subList(page.fromIndex, page.toIndex);
        if (pageElements.size() == 0) {
            Timber.tag((String)LOGGER_TAG).w("Empty page", new Object[0]);
            return null;
        }
        JSONObject params = new JSONObject();
        try {
            params.put("requests", (Object)new JSONArray(pageElements));
            if (this.mAuthtoken != null) {
                params.put(QueryParams.AUTHENTICATION_TOKEN.toString(), (Object)this.mAuthtoken);
            }
        }
        catch (JSONException e) {
            Timber.tag((String)LOGGER_TAG).w((Throwable)e, "Cannot create json object:\n%s", new Object[]{TextUtils.join((CharSequence)", ", pageElements)});
            return null;
        }
        return params;
    }

    @Nullable
    public URL getEventUrl(Page page) {
        if (page == null || page.isEmpty()) {
            return null;
        }
        try {
            return new URL(this.getApiUrl().toString() + this.mEvents.get(page.fromIndex));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public final class Page {
        protected final int fromIndex;
        protected final int toIndex;

        protected Page(int pageNumber) {
            if (pageNumber < 0 && pageNumber >= TrackerBulkURLWrapper.this.mPages) {
                this.toIndex = -1;
                this.fromIndex = -1;
                return;
            }
            this.fromIndex = pageNumber * 20;
            this.toIndex = Math.min(this.fromIndex + 20, TrackerBulkURLWrapper.this.mEvents.size());
        }

        public int elementsCount() {
            return this.toIndex - this.fromIndex;
        }

        public boolean isEmpty() {
            return this.fromIndex == -1 || this.elementsCount() == 0;
        }
    }
}

