/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.dispatcher;

import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.piwik.sdk.Piwik;
import org.piwik.sdk.dispatcher.Packet;
import org.piwik.sdk.dispatcher.TrackerBulkURLWrapper;
import timber.log.Timber;

public class Dispatcher {
    private static final String LOGGER_TAG = "PIWIK:Dispatcher";
    private final BlockingQueue<String> mDispatchQueue = new LinkedBlockingQueue<String>();
    private final Object mThreadControl = new Object();
    private final Semaphore mSleepToken = new Semaphore(0);
    private final Piwik mPiwik;
    private final URL mApiUrl;
    private final String mAuthToken;
    private List<Packet> mDryRunOutput = Collections.synchronizedList(new ArrayList());
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private volatile int mTimeOut = 5000;
    private volatile boolean mRunning = false;
    public static final long DEFAULT_DISPATCH_INTERVAL = 120000L;
    private volatile long mDispatchInterval = 120000L;
    private Runnable mLoop = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            while (Dispatcher.this.mRunning) {
                try {
                    Dispatcher.this.mSleepToken.tryAcquire(Dispatcher.this.mDispatchInterval, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int count = 0;
                ArrayList<String> availableEvents = new ArrayList<String>();
                Dispatcher.this.mDispatchQueue.drainTo(availableEvents);
                Timber.tag((String)Dispatcher.LOGGER_TAG).d("Drained %s events.", new Object[]{availableEvents.size()});
                TrackerBulkURLWrapper wrapper = new TrackerBulkURLWrapper(Dispatcher.this.mApiUrl, availableEvents, Dispatcher.this.mAuthToken);
                Iterator<TrackerBulkURLWrapper.Page> pageIterator = wrapper.iterator();
                while (pageIterator.hasNext()) {
                    TrackerBulkURLWrapper.Page page = pageIterator.next();
                    if (page.elementsCount() > 1) {
                        JSONObject eventData = wrapper.getEvents(page);
                        if (eventData == null || !Dispatcher.this.dispatch(new Packet(wrapper.getApiUrl(), eventData))) continue;
                        count += page.elementsCount();
                        continue;
                    }
                    URL targetURL = wrapper.getEventUrl(page);
                    if (targetURL == null || !Dispatcher.this.dispatch(new Packet(targetURL))) continue;
                    ++count;
                }
                Timber.tag((String)Dispatcher.LOGGER_TAG).d("Dispatched %s events.", new Object[]{count});
                Object object = Dispatcher.this.mThreadControl;
                synchronized (object) {
                    if (Dispatcher.this.mDispatchQueue.isEmpty() || Dispatcher.this.mDispatchInterval < 0L) {
                        Dispatcher.this.mRunning = false;
                        break;
                    }
                }
            }
        }
    };

    public Dispatcher(Piwik piwik, URL apiUrl, String authToken) {
        this.mPiwik = piwik;
        this.mApiUrl = apiUrl;
        this.mAuthToken = authToken;
    }

    public int getConnectionTimeOut() {
        return this.mTimeOut;
    }

    public void setConnectionTimeOut(int timeOut) {
        this.mTimeOut = timeOut;
    }

    public void setDispatchInterval(long dispatchInterval) {
        this.mDispatchInterval = dispatchInterval;
        if (this.mDispatchInterval != -1L) {
            this.launch();
        }
    }

    public long getDispatchInterval() {
        return this.mDispatchInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean launch() {
        Object object = this.mThreadControl;
        synchronized (object) {
            if (!this.mRunning) {
                this.mRunning = true;
                new Thread(this.mLoop).start();
                return true;
            }
        }
        return false;
    }

    public boolean forceDispatch() {
        if (!this.launch()) {
            this.mSleepToken.release();
            return false;
        }
        return true;
    }

    public void submit(String query) {
        this.mDispatchQueue.add(query);
        if (this.mDispatchInterval != -1L) {
            this.launch();
        }
    }

    @VisibleForTesting
    public boolean dispatch(@NonNull Packet packet) {
        if (packet.getTargetURL() == null) {
            return false;
        }
        if (packet.getJSONObject() != null && packet.getJSONObject().length() == 0) {
            return false;
        }
        if (this.mPiwik.isDryRun()) {
            this.mDryRunOutput.add(packet);
            Timber.tag((String)LOGGER_TAG).d("DryRun, stored HttpRequest, now %s.", new Object[]{this.mDryRunOutput.size()});
            return true;
        }
        if (!this.mDryRunOutput.isEmpty()) {
            this.mDryRunOutput.clear();
        }
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)packet.getTargetURL().openConnection();
            urlConnection.setConnectTimeout(this.mTimeOut);
            urlConnection.setReadTimeout(this.mTimeOut);
            if (packet.getJSONObject() != null) {
                urlConnection.setDoOutput(true);
                urlConnection.setRequestProperty("Content-Type", "application/json");
                urlConnection.setRequestProperty("charset", "utf-8");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8"));
                writer.write(packet.getJSONObject().toString());
                writer.flush();
                writer.close();
            } else {
                urlConnection.setDoOutput(false);
            }
            int statusCode = urlConnection.getResponseCode();
            Timber.tag((String)LOGGER_TAG).d("status code %s", new Object[]{statusCode});
            return statusCode == 204 || statusCode == 200;
        }
        catch (Exception e) {
            Timber.tag((String)LOGGER_TAG).w((Throwable)e, "Cannot send request", new Object[0]);
            return false;
        }
    }

    public static String urlEncodeUTF8(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            Timber.tag((String)LOGGER_TAG).e((Throwable)e, "Cannot encode %s", new Object[]{param});
            return "";
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public static String urlEncodeUTF8(Map<String, String> map) {
        StringBuilder sb = new StringBuilder(100);
        sb.append('?');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(Dispatcher.urlEncodeUTF8(entry.getKey()));
            sb.append('=');
            sb.append(Dispatcher.urlEncodeUTF8(entry.getValue()));
            sb.append('&');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public List<Packet> getDryRunOutput() {
        return this.mDryRunOutput;
    }
}

