/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.piwik.sdk.CustomVariables;
import org.piwik.sdk.Piwik;
import org.piwik.sdk.QueryParams;
import org.piwik.sdk.TrackMe;
import org.piwik.sdk.dispatcher.Dispatcher;
import org.piwik.sdk.tools.DeviceHelper;
import timber.log.Timber;

public class Tracker {
    protected static final String LOGGER_TAG = "PIWIK:Tracker";
    private static final String DEFAULT_UNKNOWN_VALUE = "unknown";
    private static final String DEFAULT_TRUE_VALUE = "1";
    private static final String DEFAULT_RECORD_VALUE = "1";
    private static final String DEFAULT_API_VERSION_VALUE = "1";
    protected static final String PREF_KEY_TRACKER_USERID = "tracker.userid";
    protected static final String PREF_KEY_TRACKER_FIRSTVISIT = "tracker.firstvisit";
    protected static final String PREF_KEY_TRACKER_VISITCOUNT = "tracker.visitcount";
    protected static final String PREF_KEY_TRACKER_PREVIOUSVISIT = "tracker.previousvisit";
    private final Piwik mPiwik;
    private final URL mApiUrl;
    private final int mSiteId;
    private final String mAuthToken;
    private final Object mSessionLock = new Object();
    private final CustomVariables mVisitCustomVariable = new CustomVariables();
    private final Dispatcher mDispatcher;
    private final Random mRandomAntiCachingValue = new Random(new Date().getTime());
    private final TrackMe mDefaultTrackMe = new TrackMe();
    private String mLastEvent;
    private String mApplicationDomain;
    private long mSessionTimeout = 1800000L;
    private long mSessionStartTime;
    private static final Pattern PATTERN_VISITOR_ID = Pattern.compile("^[0-9a-f]{16}$");
    private CountDownLatch mSessionStartLatch = new CountDownLatch(0);

    protected Tracker(@NonNull String url, int siteId, String authToken, @NonNull Piwik piwik) throws MalformedURLException {
        String checkUrl = url;
        if (checkUrl.endsWith("piwik.php") || checkUrl.endsWith("piwik-proxy.php")) {
            this.mApiUrl = new URL(checkUrl);
        } else {
            if (!checkUrl.endsWith("/")) {
                checkUrl = checkUrl + "/";
            }
            this.mApiUrl = new URL(checkUrl + "piwik.php");
        }
        this.mPiwik = piwik;
        this.mSiteId = siteId;
        this.mAuthToken = authToken;
        this.mDispatcher = new Dispatcher(this.mPiwik, this.mApiUrl, authToken);
        String userId = this.getSharedPreferences().getString(PREF_KEY_TRACKER_USERID, null);
        if (userId == null) {
            userId = UUID.randomUUID().toString();
            this.getSharedPreferences().edit().putString(PREF_KEY_TRACKER_USERID, userId).apply();
        }
        this.mDefaultTrackMe.set(QueryParams.USER_ID, userId);
        this.mDefaultTrackMe.set(QueryParams.SESSION_START, "1");
        String resolution = DEFAULT_UNKNOWN_VALUE;
        int[] res = DeviceHelper.getResolution(this.mPiwik.getContext());
        if (res != null) {
            resolution = String.format("%sx%s", res[0], res[1]);
        }
        this.mDefaultTrackMe.set(QueryParams.SCREEN_RESOLUTION, resolution);
        this.mDefaultTrackMe.set(QueryParams.USER_AGENT, DeviceHelper.getUserAgent());
        this.mDefaultTrackMe.set(QueryParams.LANGUAGE, DeviceHelper.getUserLanguage());
        this.mDefaultTrackMe.set(QueryParams.COUNTRY, DeviceHelper.getUserCountry());
        this.mDefaultTrackMe.set(QueryParams.VISITOR_ID, Tracker.makeRandomVisitorId());
        this.mDefaultTrackMe.set(QueryParams.URL_PATH, Tracker.fixUrl(null, this.getApplicationBaseURL()));
    }

    public Piwik getPiwik() {
        return this.mPiwik;
    }

    public URL getAPIUrl() {
        return this.mApiUrl;
    }

    public String getAuthToken() {
        return this.mAuthToken;
    }

    protected int getSiteId() {
        return this.mSiteId;
    }

    public TrackMe getDefaultTrackMe() {
        return this.mDefaultTrackMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewSession() {
        Object object = this.mSessionLock;
        synchronized (object) {
            this.mSessionStartTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionTimeout(int milliseconds) {
        Object object = this.mSessionLock;
        synchronized (object) {
            this.mSessionTimeout = milliseconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryNewSession() {
        Object object = this.mSessionLock;
        synchronized (object) {
            boolean expired = System.currentTimeMillis() - this.mSessionStartTime > this.mSessionTimeout;
            this.mSessionStartTime = System.currentTimeMillis();
            return expired;
        }
    }

    public long getSessionTimeout() {
        return this.mSessionTimeout;
    }

    public int getDispatchTimeout() {
        return this.mDispatcher.getConnectionTimeOut();
    }

    public void setDispatchTimeout(int timeout) {
        this.mDispatcher.setConnectionTimeOut(timeout);
    }

    public boolean dispatch() {
        if (!this.mPiwik.isOptOut()) {
            this.mDispatcher.forceDispatch();
            return true;
        }
        return false;
    }

    public Tracker setDispatchInterval(long dispatchInterval) {
        this.mDispatcher.setDispatchInterval(dispatchInterval);
        return this;
    }

    public long getDispatchInterval() {
        return this.mDispatcher.getDispatchInterval();
    }

    public Tracker setUserId(String userId) {
        this.mDefaultTrackMe.set(QueryParams.USER_ID, userId);
        this.getSharedPreferences().edit().putString(PREF_KEY_TRACKER_USERID, userId).apply();
        return this;
    }

    public String getUserId() {
        return this.mDefaultTrackMe.get(QueryParams.USER_ID);
    }

    public Tracker setVisitorId(String visitorId) throws IllegalArgumentException {
        if (this.confirmVisitorIdFormat(visitorId)) {
            this.mDefaultTrackMe.set(QueryParams.VISITOR_ID, visitorId);
        }
        return this;
    }

    public String getVisitorId() {
        return this.mDefaultTrackMe.get(QueryParams.VISITOR_ID);
    }

    private boolean confirmVisitorIdFormat(String visitorId) throws IllegalArgumentException {
        Matcher visitorIdMatcher = PATTERN_VISITOR_ID.matcher(visitorId);
        if (visitorIdMatcher.matches()) {
            return true;
        }
        throw new IllegalArgumentException("VisitorId: " + visitorId + " is not of valid format, " + " the format must match the regular expression: " + PATTERN_VISITOR_ID.pattern());
    }

    public Tracker setApplicationDomain(String domain) {
        this.mApplicationDomain = domain;
        this.mDefaultTrackMe.set(QueryParams.URL_PATH, Tracker.fixUrl(null, this.getApplicationBaseURL()));
        return this;
    }

    protected String getApplicationDomain() {
        return this.mApplicationDomain != null ? this.mApplicationDomain : this.mPiwik.getApplicationDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectInitialParams(TrackMe trackMe) {
        long previousVisit;
        long firstVisitTime;
        int visitCount;
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        synchronized (sharedPreferences) {
            visitCount = 1 + this.getSharedPreferences().getInt(PREF_KEY_TRACKER_VISITCOUNT, 0);
            this.getSharedPreferences().edit().putInt(PREF_KEY_TRACKER_VISITCOUNT, visitCount).apply();
        }
        sharedPreferences = this.getSharedPreferences();
        synchronized (sharedPreferences) {
            firstVisitTime = this.getSharedPreferences().getLong(PREF_KEY_TRACKER_FIRSTVISIT, -1L);
            if (firstVisitTime == -1L) {
                firstVisitTime = System.currentTimeMillis() / 1000L;
                this.getSharedPreferences().edit().putLong(PREF_KEY_TRACKER_FIRSTVISIT, firstVisitTime).apply();
            }
        }
        sharedPreferences = this.getSharedPreferences();
        synchronized (sharedPreferences) {
            previousVisit = this.getSharedPreferences().getLong(PREF_KEY_TRACKER_PREVIOUSVISIT, -1L);
            this.getSharedPreferences().edit().putLong(PREF_KEY_TRACKER_PREVIOUSVISIT, System.currentTimeMillis() / 1000L).apply();
        }
        this.mDefaultTrackMe.trySet(QueryParams.FIRST_VISIT_TIMESTAMP, firstVisitTime);
        this.mDefaultTrackMe.trySet(QueryParams.TOTAL_NUMBER_OF_VISITS, visitCount);
        if (previousVisit != -1L) {
            this.mDefaultTrackMe.trySet(QueryParams.PREVIOUS_VISIT_TIMESTAMP, previousVisit);
        }
        trackMe.trySet(QueryParams.SESSION_START, this.mDefaultTrackMe.get(QueryParams.SESSION_START));
        trackMe.trySet(QueryParams.SCREEN_RESOLUTION, this.mDefaultTrackMe.get(QueryParams.SCREEN_RESOLUTION));
        trackMe.trySet(QueryParams.USER_AGENT, this.mDefaultTrackMe.get(QueryParams.USER_AGENT));
        trackMe.trySet(QueryParams.LANGUAGE, this.mDefaultTrackMe.get(QueryParams.LANGUAGE));
        trackMe.trySet(QueryParams.COUNTRY, this.mDefaultTrackMe.get(QueryParams.COUNTRY));
        trackMe.trySet(QueryParams.FIRST_VISIT_TIMESTAMP, this.mDefaultTrackMe.get(QueryParams.FIRST_VISIT_TIMESTAMP));
        trackMe.trySet(QueryParams.TOTAL_NUMBER_OF_VISITS, this.mDefaultTrackMe.get(QueryParams.TOTAL_NUMBER_OF_VISITS));
        trackMe.trySet(QueryParams.PREVIOUS_VISIT_TIMESTAMP, this.mDefaultTrackMe.get(QueryParams.PREVIOUS_VISIT_TIMESTAMP));
    }

    private void injectBaseParams(TrackMe trackMe) {
        trackMe.trySet(QueryParams.SITE_ID, this.mSiteId);
        trackMe.trySet(QueryParams.RECORD, "1");
        trackMe.trySet(QueryParams.API_VERSION, "1");
        trackMe.trySet(QueryParams.RANDOM_NUMBER, this.mRandomAntiCachingValue.nextInt(100000));
        trackMe.trySet(QueryParams.DATETIME_OF_REQUEST, new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ").format(new Date()));
        trackMe.trySet(QueryParams.SEND_IMAGE, "0");
        trackMe.trySet(QueryParams.VISITOR_ID, this.mDefaultTrackMe.get(QueryParams.VISITOR_ID));
        trackMe.trySet(QueryParams.USER_ID, this.mDefaultTrackMe.get(QueryParams.USER_ID));
        trackMe.trySet(QueryParams.VISIT_SCOPE_CUSTOM_VARIABLES, this.mVisitCustomVariable.toString());
        String urlPath = trackMe.get(QueryParams.URL_PATH);
        if (urlPath == null) {
            urlPath = this.mDefaultTrackMe.get(QueryParams.URL_PATH);
        } else {
            urlPath = Tracker.fixUrl(urlPath, this.getApplicationBaseURL());
            this.mDefaultTrackMe.set(QueryParams.URL_PATH, urlPath);
        }
        trackMe.set(QueryParams.URL_PATH, urlPath);
    }

    private static String fixUrl(String url, String baseUrl) {
        if (url == null) {
            url = baseUrl + "/";
        }
        if (!(url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://"))) {
            url = baseUrl + (url.startsWith("/") ? "" : "/") + url;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker track(TrackMe trackMe) {
        boolean newSession;
        Object object = this.mSessionLock;
        synchronized (object) {
            newSession = this.tryNewSession();
            if (newSession) {
                this.mSessionStartLatch = new CountDownLatch(1);
            }
        }
        if (newSession) {
            this.injectInitialParams(trackMe);
        } else {
            try {
                this.mSessionStartLatch.await(this.mDispatcher.getConnectionTimeOut(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.injectBaseParams(trackMe);
        String event = Dispatcher.urlEncodeUTF8(trackMe.toMap());
        if (this.mPiwik.isOptOut()) {
            this.mLastEvent = event;
            Timber.tag((String)LOGGER_TAG).d("URL omitted due to opt out: %s", new Object[]{event});
        } else {
            this.mDispatcher.submit(event);
            Timber.tag((String)LOGGER_TAG).d("URL added to the queue: %s", new Object[]{event});
        }
        if (newSession) {
            this.mSessionStartLatch.countDown();
        }
        return this;
    }

    public static String makeRandomVisitorId() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 16);
    }

    public Tracker setVisitCustomVariable(int index, String name, String value) {
        this.mVisitCustomVariable.put(index, name, value);
        return this;
    }

    public SharedPreferences getSharedPreferences() {
        return this.mPiwik.getSharedPreferences();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tracker tracker = (Tracker)o;
        return this.mSiteId == tracker.mSiteId && this.mApiUrl.equals(tracker.mApiUrl);
    }

    public int hashCode() {
        int result = this.mSiteId;
        result = 31 * result + this.mApiUrl.hashCode();
        return result;
    }

    protected String getApplicationBaseURL() {
        return String.format("http://%s", this.getApplicationDomain());
    }

    @VisibleForTesting
    public String getLastEvent() {
        return this.mLastEvent;
    }

    @VisibleForTesting
    public void clearLastEvent() {
        this.mLastEvent = null;
    }

    @VisibleForTesting
    public Dispatcher getDispatcher() {
        return this.mDispatcher;
    }
}

