/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk;

import org.piwik.sdk.TrackHelper;
import org.piwik.sdk.TrackMe;
import org.piwik.sdk.Tracker;
import timber.log.Timber;

public class PiwikExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Tracker mTracker;
    private final TrackMe mTrackMe;
    private final Thread.UncaughtExceptionHandler mDefaultExceptionHandler;

    public PiwikExceptionHandler(Tracker tracker, TrackMe trackMe) {
        this.mTracker = tracker;
        this.mTrackMe = trackMe;
        this.mDefaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    public Tracker getTracker() {
        return this.mTracker;
    }

    public Thread.UncaughtExceptionHandler getDefaultExceptionHandler() {
        return this.mDefaultExceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        try {
            String excInfo = ex.getMessage();
            TrackHelper.track().exception(ex).description(excInfo).fatal(true).with(this.getTracker());
            this.getTracker().dispatch();
        }
        catch (Exception e) {
            Timber.tag((String)"PIWIK:Tracker").e((Throwable)e, "Couldn't track uncaught exception", new Object[0]);
        }
        finally {
            if (this.getDefaultExceptionHandler() != null && this.getDefaultExceptionHandler() != this) {
                this.getDefaultExceptionHandler().uncaughtException(thread, ex);
            }
        }
    }
}

