/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import java.net.MalformedURLException;
import org.piwik.sdk.Piwik;
import org.piwik.sdk.Tracker;

public abstract class PiwikApplication
extends Application {
    private Tracker mPiwikTracker;

    public Piwik getPiwik() {
        return Piwik.getInstance((Context)this);
    }

    public synchronized Tracker getTracker() {
        if (this.mPiwikTracker == null) {
            try {
                this.mPiwikTracker = this.getPiwik().newTracker(this.getTrackerUrl(), this.getSiteId());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new RuntimeException("Tracker URL was malformed.");
            }
        }
        return this.mPiwikTracker;
    }

    public abstract String getTrackerUrl();

    public abstract Integer getSiteId();

    public void onLowMemory() {
        if (Build.VERSION.SDK_INT < 14 && this.mPiwikTracker != null) {
            this.mPiwikTracker.dispatch();
        }
        super.onLowMemory();
    }

    public void onTrimMemory(int level) {
        if ((level == 20 || level == 80) && this.mPiwikTracker != null) {
            this.mPiwikTracker.dispatch();
        }
        super.onTrimMemory(level);
    }
}

