/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import java.net.MalformedURLException;
import org.piwik.sdk.Tracker;

public class Piwik {
    public static final String LOGGER_PREFIX = "PIWIK:";
    public static final String PREFERENCE_FILE_NAME = "org.piwik.sdk";
    public static final String PREFERENCE_KEY_OPTOUT = "piwik.optout";
    private final Context mContext;
    private boolean mOptOut = false;
    private boolean mDryRun = false;
    private static Piwik sInstance;
    private final SharedPreferences mSharedPreferences;

    public static synchronized Piwik getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new Piwik(context);
        }
        return sInstance;
    }

    private Piwik(Context context) {
        this.mContext = context.getApplicationContext();
        this.mSharedPreferences = this.getContext().getSharedPreferences(PREFERENCE_FILE_NAME, 0);
        this.mOptOut = this.getSharedPreferences().getBoolean(PREFERENCE_KEY_OPTOUT, false);
    }

    protected Context getContext() {
        return this.mContext;
    }

    @Deprecated
    public synchronized Tracker newTracker(@NonNull String trackerUrl, int siteId, String authToken) throws MalformedURLException {
        return new Tracker(trackerUrl, siteId, authToken, this);
    }

    public synchronized Tracker newTracker(@NonNull String trackerUrl, int siteId) throws MalformedURLException {
        return new Tracker(trackerUrl, siteId, null, this);
    }

    public void setOptOut(boolean optOut) {
        this.mOptOut = optOut;
        this.getSharedPreferences().edit().putBoolean(PREFERENCE_KEY_OPTOUT, optOut).apply();
    }

    public boolean isOptOut() {
        return this.mOptOut;
    }

    public boolean isDryRun() {
        return this.mDryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.mDryRun = dryRun;
    }

    public String getApplicationDomain() {
        return this.getContext().getPackageName();
    }

    public SharedPreferences getSharedPreferences() {
        return this.mSharedPreferences;
    }
}

