/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk;

import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.File;
import org.piwik.sdk.QueryParams;
import org.piwik.sdk.TrackMe;
import org.piwik.sdk.Tracker;
import org.piwik.sdk.tools.Checksum;
import timber.log.Timber;

public class DownloadTracker {
    protected static final String LOGGER_TAG = "PIWIK:DownloadTrackingHelper";
    private static final String INSTALL_SOURCE_GOOGLE_PLAY = "com.android.vending";
    private final Tracker mTracker;
    private final TrackMe mBaseTrackMe;
    private final Object TRACK_ONCE_LOCK = new Object();
    private final PackageManager mPackMan;
    private final String mPackageName;
    private final SharedPreferences mPreferences;
    private String mVersion;
    private PackageInfo mPkgInfo;

    public DownloadTracker(Tracker tracker) {
        this(tracker, new TrackMe());
    }

    public DownloadTracker(Tracker tracker, TrackMe baseTrackMe) {
        this.mTracker = tracker;
        this.mBaseTrackMe = baseTrackMe;
        this.mPreferences = tracker.getPiwik().getSharedPreferences();
        this.mPackageName = tracker.getPiwik().getContext().getPackageName();
        this.mPackMan = tracker.getPiwik().getContext().getPackageManager();
        try {
            this.mPkgInfo = this.mPackMan.getPackageInfo(this.mPackageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setVersion(@Nullable String version) {
        this.mVersion = version;
    }

    public String getVersion() {
        if (this.mVersion != null) {
            return this.mVersion;
        }
        return Integer.toString(this.mPkgInfo.versionCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackOnce(@NonNull Extra extra) {
        String firedKey = "downloaded:" + this.mPackageName + ":" + this.getVersion();
        Object object = this.TRACK_ONCE_LOCK;
        synchronized (object) {
            if (!this.mPreferences.getBoolean(firedKey, false)) {
                this.mPreferences.edit().putBoolean(firedKey, true).apply();
                this.trackNewAppDownload(extra);
            }
        }
    }

    public void trackNewAppDownload(final @NonNull Extra extra) {
        final Thread trackTask = new Thread(new Runnable(){

            @Override
            public void run() {
                DownloadTracker.this.trackNewAppDownloadInternal(extra);
            }
        });
        boolean delay = INSTALL_SOURCE_GOOGLE_PLAY.equals(this.mPackMan.getInstallerPackageName(this.mPackageName));
        if (delay) {
            Timber.tag((String)LOGGER_TAG).d("Google Play is install source, deferring tracking.", new Object[0]);
        }
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                if (extra == Extra.APK_CHECKSUM) {
                    trackTask.start();
                } else {
                    trackTask.run();
                }
            }
        }, delay ? 3000L : 0L);
    }

    private void trackNewAppDownloadInternal(@NonNull Extra extra) {
        String referrerExtras;
        String referringApp;
        Timber.tag((String)LOGGER_TAG).d("Tracking app download...", new Object[0]);
        StringBuilder installIdentifier = new StringBuilder();
        installIdentifier.append("http://").append(this.mPackageName).append(":").append(this.getVersion());
        if (extra == Extra.APK_CHECKSUM) {
            if (this.mPkgInfo == null) {
                return;
            }
            if (this.mPkgInfo.applicationInfo != null && this.mPkgInfo.applicationInfo.sourceDir != null) {
                try {
                    String md5Identifier = Checksum.getMD5Checksum(new File(this.mPkgInfo.applicationInfo.sourceDir));
                    if (md5Identifier != null) {
                        installIdentifier.append("/").append(md5Identifier);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((referringApp = this.mPackMan.getInstallerPackageName(this.mPackageName)) != null && referringApp.length() > 200) {
            referringApp = referringApp.substring(0, 200);
        }
        if (referringApp != null && referringApp.equals(INSTALL_SOURCE_GOOGLE_PLAY) && (referrerExtras = this.mPreferences.getString("referrer.extras", null)) != null) {
            referringApp = referringApp + "/?" + referrerExtras;
        }
        if (referringApp != null) {
            referringApp = "http://" + referringApp;
        }
        this.mTracker.track(new TrackMe(this.mBaseTrackMe).set(QueryParams.EVENT_CATEGORY, "Application").set(QueryParams.EVENT_ACTION, "downloaded").set(QueryParams.ACTION_NAME, "application/downloaded").set(QueryParams.URL_PATH, "/application/downloaded").set(QueryParams.DOWNLOAD, installIdentifier.toString()).set(QueryParams.REFERRER, referringApp));
        Timber.tag((String)LOGGER_TAG).d("... app download tracked.", new Object[0]);
    }

    public static enum Extra {
        APK_CHECKSUM,
        NONE;

    }
}

