/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import timber.log.Timber;

public class CustomVariables {
    private final Map<String, JSONArray> mVars = new ConcurrentHashMap<String, JSONArray>();
    private static final String LOGGER_TAG = "PIWIK:CustomVariables";
    protected static final int MAX_LENGTH = 200;

    public CustomVariables() {
    }

    public CustomVariables(CustomVariables variables) {
        this.mVars.putAll(variables.mVars);
    }

    public JSONArray put(int index, String name, String value) {
        if (index > 0 && name != null & value != null) {
            if (name.length() > 200) {
                Timber.tag((String)LOGGER_TAG).w("Name is too long %s", new Object[]{name});
                name = name.substring(0, 200);
            }
            if (value.length() > 200) {
                Timber.tag((String)LOGGER_TAG).w("Value is too long %s", new Object[]{value});
                value = value.substring(0, 200);
            }
            return this.put(Integer.toString(index), new JSONArray(Arrays.asList(name, value)));
        }
        Timber.tag((String)LOGGER_TAG).w("Index is out of range or name/value is null", new Object[0]);
        return null;
    }

    public JSONArray put(String index, JSONArray values) {
        if (values.length() != 2 || index == null) {
            Timber.tag((String)LOGGER_TAG).w("values.length() should be equal 2", new Object[0]);
            return null;
        }
        return this.mVars.put(index, values);
    }

    public String toString() {
        JSONObject json = new JSONObject(this.mVars);
        return json.length() > 0 ? json.toString() : null;
    }
}

