/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.util.Optional;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.Repository;

public class TestToClassMapper {
    private static final int TEST_LENGTH = "Test".length();
    private final Repository repository;

    public TestToClassMapper(Repository repository) {
        this.repository = repository;
    }

    public Optional<ClassName> findTestee(String className) {
        ClassName name = ClassName.fromString((String)className);
        if (name.asJavaName().endsWith("Test") && this.tryName(name.withoutSuffixChars(TEST_LENGTH))) {
            return Optional.ofNullable(name.withoutSuffixChars(TEST_LENGTH));
        }
        if (name.getNameWithoutPackage().asJavaName().startsWith("Test") && this.tryName(name.withoutPrefixChars(TEST_LENGTH))) {
            return Optional.ofNullable(name.withoutPrefixChars(TEST_LENGTH));
        }
        return Optional.empty();
    }

    private boolean tryName(ClassName name) {
        return this.repository.hasClass(name);
    }
}

