/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationMetaData;
import org.pitest.mutationtest.MutationStatusMap;
import org.pitest.mutationtest.build.MutationAnalysisUnit;
import org.pitest.mutationtest.build.WorkerFactory;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.execute.MutationTestProcess;
import org.pitest.util.ExitCode;
import org.pitest.util.Log;

public class MutationTestUnit
implements MutationAnalysisUnit {
    private static final Logger LOG = Log.getLogger();
    private final Collection<MutationDetails> availableMutations;
    private final WorkerFactory workerFactory;
    private final Collection<ClassName> testClasses;

    public MutationTestUnit(Collection<MutationDetails> availableMutations, Collection<ClassName> testClasses, WorkerFactory workerFactor) {
        this.availableMutations = availableMutations;
        this.testClasses = testClasses;
        this.workerFactory = workerFactor;
    }

    @Override
    public MutationMetaData call() throws Exception {
        MutationStatusMap mutations = new MutationStatusMap();
        mutations.setStatusForMutations(this.availableMutations, DetectionStatus.NOT_STARTED);
        mutations.markUncoveredMutations();
        this.runTestsInSeperateProcess(mutations);
        return MutationTestUnit.reportResults(mutations);
    }

    @Override
    public int priority() {
        return this.availableMutations.size();
    }

    private void runTestsInSeperateProcess(MutationStatusMap mutations) throws IOException, InterruptedException {
        while (mutations.hasUnrunMutations()) {
            this.runTestInSeperateProcessForMutationRange(mutations);
        }
    }

    private void runTestInSeperateProcessForMutationRange(MutationStatusMap mutations) throws IOException, InterruptedException {
        Collection<MutationDetails> remainingMutations = mutations.getUnrunMutations();
        MutationTestProcess worker = this.workerFactory.createWorker(remainingMutations, this.testClasses);
        worker.start();
        MutationTestUnit.setFirstMutationToStatusOfStartedInCaseMinionFailsAtBoot(mutations, remainingMutations);
        ExitCode exitCode = MutationTestUnit.waitForMinionToDie(worker);
        worker.results(mutations);
        MutationTestUnit.correctResultForProcessExitCode(mutations, exitCode);
    }

    private static ExitCode waitForMinionToDie(MutationTestProcess worker) {
        ExitCode exitCode = worker.waitToDie();
        LOG.fine("Exit code was - " + exitCode);
        return exitCode;
    }

    private static void setFirstMutationToStatusOfStartedInCaseMinionFailsAtBoot(MutationStatusMap mutations, Collection<MutationDetails> remainingMutations) {
        mutations.setStatusForMutation(remainingMutations.iterator().next(), DetectionStatus.STARTED);
    }

    private static void correctResultForProcessExitCode(MutationStatusMap mutations, ExitCode exitCode) {
        if (!exitCode.isOk()) {
            Collection<MutationDetails> unfinishedRuns = mutations.getUnfinishedRuns();
            DetectionStatus status = DetectionStatus.getForErrorExitCode((ExitCode)exitCode);
            LOG.warning("Minion exited abnormally due to " + status);
            LOG.fine("Setting " + unfinishedRuns.size() + " unfinished runs to " + status + " state");
            mutations.setStatusForMutations(unfinishedRuns, status);
        } else {
            LOG.fine("Minion exited ok");
        }
    }

    private static MutationMetaData reportResults(MutationStatusMap mutationsMap) {
        return new MutationMetaData(mutationsMap.createMutationResults());
    }
}

