/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.statistics.MutationStatistics;
import org.pitest.mutationtest.statistics.Score;
import org.pitest.mutationtest.statistics.ScorePrecursor;

class MutationStatisticsPrecursor {
    private final Map<String, ScorePrecursor> mutatorTotalMap = new HashMap<String, ScorePrecursor>();
    private long numberOfTestsRun = 0L;

    MutationStatisticsPrecursor() {
    }

    public void registerResults(Collection<MutationResult> results) {
        results.forEach(this.register());
    }

    private Consumer<MutationResult> register() {
        return mr -> {
            this.numberOfTestsRun += (long)mr.getNumberOfTestsRun();
            String key = mr.getDetails().getId().getMutator();
            ScorePrecursor total = this.mutatorTotalMap.get(key);
            if (total == null) {
                total = new ScorePrecursor(key);
                this.mutatorTotalMap.put(key, total);
            }
            total.registerResult(mr.getStatus());
        };
    }

    public MutationStatistics toStatistics() {
        Iterable<Score> scores = this.getScores();
        long totalMutations = (Long)FCollection.fold(MutationStatisticsPrecursor.addTotals(), (Object)0L, scores);
        long totalDetected = (Long)FCollection.fold(MutationStatisticsPrecursor.addDetectedTotals(), (Object)0L, scores);
        return new MutationStatistics(scores, totalMutations, totalDetected, this.numberOfTestsRun);
    }

    Iterable<Score> getScores() {
        return FCollection.map(this.mutatorTotalMap.values(), MutationStatisticsPrecursor.toScore());
    }

    private static Function<ScorePrecursor, Score> toScore() {
        return a -> a.toScore();
    }

    private static BiFunction<Long, Score, Long> addTotals() {
        return (a, b) -> a + b.getTotalMutations();
    }

    private static BiFunction<Long, Score, Long> addDetectedTotals() {
        return (a, b) -> a + b.getTotalDetectedMutations();
    }
}

