/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class TryWithResourcesMethodVisitor
extends MethodVisitor {
    private static final List<Integer> JAVAC_CLASS_INS_SEQUENCE = Arrays.asList(58, 25, 198, 25, 198, 25, 182, 167, 58, 25, 25, 182, 167, 25, 182, 25, 191);
    private static final List<Integer> JAVAC_INTERFACE_INS_SEQUENCE = Arrays.asList(58, 25, 198, 25, 198, 25, 185, 167, 58, 25, 25, 182, 167, 25, 185, 25, 191);
    private static final List<Integer> ECJ_INS_SEQUENCE = Arrays.asList(58, 25, 199, 25, 58, 167, 25, 25, 165, 25, 25, 182, 25, 191);
    private final Set<Integer> lines;
    private final List<Integer> opcodesStack = new ArrayList<Integer>();
    private int currentLineNumber;

    TryWithResourcesMethodVisitor(Set<Integer> lines) {
        super(524288);
        this.lines = lines;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.prepareToStartTracking();
        this.currentLineNumber = line;
        super.visitLineNumber(line, start);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.opcodesStack.add(opcode);
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.opcodesStack.add(opcode);
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.opcodesStack.add(opcode);
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 191) {
            this.opcodesStack.add(opcode);
            this.finishTracking();
        }
        super.visitInsn(opcode);
    }

    private void finishTracking() {
        if (JAVAC_CLASS_INS_SEQUENCE.equals(this.opcodesStack) || JAVAC_INTERFACE_INS_SEQUENCE.equals(this.opcodesStack) || ECJ_INS_SEQUENCE.equals(this.opcodesStack)) {
            this.lines.add(this.currentLineNumber);
        }
        this.prepareToStartTracking();
    }

    private void prepareToStartTracking() {
        if (!this.opcodesStack.isEmpty()) {
            this.opcodesStack.clear();
        }
    }
}

