/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.TestInfo;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationAnalyser;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.build.AnalysisPriorityComparator;
import org.pitest.mutationtest.build.KnownStatusMutationTestUnit;
import org.pitest.mutationtest.build.MutationAnalysisUnit;
import org.pitest.mutationtest.build.MutationGrouper;
import org.pitest.mutationtest.build.MutationSource;
import org.pitest.mutationtest.build.MutationTestUnit;
import org.pitest.mutationtest.build.WorkerFactory;
import org.pitest.mutationtest.engine.MutationDetails;

public class MutationTestBuilder {
    private final MutationSource mutationSource;
    private final MutationAnalyser analyser;
    private final WorkerFactory workerFactory;
    private final MutationGrouper grouper;

    public MutationTestBuilder(WorkerFactory workerFactory, MutationAnalyser analyser, MutationSource mutationSource, MutationGrouper grouper) {
        this.mutationSource = mutationSource;
        this.analyser = analyser;
        this.workerFactory = workerFactory;
        this.grouper = grouper;
    }

    public List<MutationAnalysisUnit> createMutationTestUnits(Collection<ClassName> codeClasses) {
        ArrayList<MutationAnalysisUnit> tus = new ArrayList<MutationAnalysisUnit>();
        List mutations = FCollection.flatMap(codeClasses, this.classToMutations());
        mutations.sort(Comparator.comparing(MutationDetails::getId));
        Collection<MutationResult> analysedMutations = this.analyser.analyse(mutations);
        Collection needAnalysis = analysedMutations.stream().filter(MutationTestBuilder.statusNotKnown()).map(MutationTestBuilder.resultToDetails()).collect(Collectors.toList());
        List analysed = FCollection.filter(analysedMutations, (Predicate)Prelude.not(MutationTestBuilder.statusNotKnown()));
        if (!analysed.isEmpty()) {
            tus.add(this.makePreAnalysedUnit(analysed));
        }
        if (!needAnalysis.isEmpty()) {
            for (Collection collection : this.grouper.groupMutations(codeClasses, needAnalysis)) {
                tus.add(this.makeUnanalysedUnit(collection));
            }
        }
        tus.sort(new AnalysisPriorityComparator());
        return tus;
    }

    private Function<ClassName, Iterable<MutationDetails>> classToMutations() {
        return a -> this.mutationSource.createMutations((ClassName)a);
    }

    private MutationAnalysisUnit makePreAnalysedUnit(List<MutationResult> analysed) {
        return new KnownStatusMutationTestUnit(analysed);
    }

    private MutationAnalysisUnit makeUnanalysedUnit(Collection<MutationDetails> needAnalysis) {
        HashSet<ClassName> uniqueTestClasses = new HashSet<ClassName>();
        FCollection.flatMapTo(needAnalysis, MutationTestBuilder.mutationDetailsToTestClass(), uniqueTestClasses);
        return new MutationTestUnit(needAnalysis, uniqueTestClasses, this.workerFactory);
    }

    private static Function<MutationResult, MutationDetails> resultToDetails() {
        return a -> a.getDetails();
    }

    private static Predicate<MutationResult> statusNotKnown() {
        return a -> a.getStatus() == DetectionStatus.NOT_STARTED;
    }

    private static Function<MutationDetails, Iterable<ClassName>> mutationDetailsToTestClass() {
        return a -> FCollection.map((Iterable)a.getTestsInOrder(), (Function)TestInfo.toDefiningClassName());
    }
}

