/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.build.MutationGrouper;
import org.pitest.mutationtest.engine.MutationDetails;

public class DefaultGrouper
implements MutationGrouper {
    private final int unitSize;

    public DefaultGrouper(int unitSize) {
        this.unitSize = unitSize;
    }

    @Override
    public List<List<MutationDetails>> groupMutations(Collection<ClassName> codeClasses, Collection<MutationDetails> mutations) {
        Map bucketed = FCollection.bucket(mutations, DefaultGrouper.byClass());
        ArrayList<List<MutationDetails>> chunked = new ArrayList<List<MutationDetails>>();
        for (Collection each : bucketed.values()) {
            this.shrinkToMaximumUnitSize(chunked, each);
        }
        return chunked;
    }

    private void shrinkToMaximumUnitSize(List<List<MutationDetails>> chunked, Collection<MutationDetails> each) {
        if (this.unitSize > 0) {
            for (List ms : FCollection.splitToLength((int)this.unitSize, each)) {
                chunked.add(ms);
            }
        } else {
            chunked.add(new ArrayList<MutationDetails>(each));
        }
    }

    private static Function<MutationDetails, ClassName> byClass() {
        return a -> a.getClassName();
    }
}

