/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.pitest.util.PitError;

public abstract class ServiceLoader {
    public static <S> Collection<S> load(Class<S> ifc) {
        return ServiceLoader.load(ifc, Thread.currentThread().getContextClassLoader());
    }

    public static <S> Collection<S> load(Class<S> ifc, ClassLoader loader) {
        try {
            return ServiceLoader.loadImpl(ifc, loader);
        }
        catch (IOException ex) {
            throw new PitError("Error creating service " + ifc.getName(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S> Collection<S> loadImpl(Class<S> ifc, ClassLoader loader) throws IOException {
        Enumeration<URL> e = loader.getResources("META-INF/services/" + ifc.getName());
        ArrayList services = new ArrayList();
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            InputStream is = url.openStream();
            try {
                ServiceLoader.createServicesFromStream(ifc, loader, services, is);
            }
            finally {
                is.close();
            }
        }
        return services;
    }

    private static <S> void createServicesFromStream(Class<S> ifc, ClassLoader loader, Collection<S> services, InputStream is) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        while ((line = r.readLine()) != null) {
            String name;
            int comment = line.indexOf(35);
            if (comment >= 0) {
                line = line.substring(0, comment);
            }
            if ((name = line.trim()).length() == 0) continue;
            services.add(ServiceLoader.createService(name, ifc, loader));
        }
    }

    private static <S> S createService(String name, Class<S> ifc, ClassLoader loader) {
        try {
            Class<?> clz = Class.forName(name, true, loader);
            Class<S> impl = clz.asSubclass(ifc);
            Constructor<S> ctor = impl.getConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new PitError("Error creating service " + ifc.getName(), (Throwable)ex);
        }
    }
}

