/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.pitest.boot.HotSwapAgent;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.functional.Option;
import org.pitest.process.JavaAgent;
import org.pitest.util.FileUtil;
import org.pitest.util.PitError;
import org.pitest.util.Unchecked;
import sun.pitest.CodeCoverageStore;
import sun.pitest.InvokeReceiver;

public class JarCreatingJarFinder
implements JavaAgent {
    protected static final String CAN_REDEFINE_CLASSES = "Can-Redefine-Classes";
    protected static final String PREMAIN_CLASS = "Premain-Class";
    protected static final String CAN_SET_NATIVE_METHOD = "Can-Set-Native-Method-Prefix";
    protected static final String BOOT_CLASSPATH = "Boot-Class-Path";
    private static final String AGENT_CLASS_NAME = HotSwapAgent.class.getName();
    private Option<String> location = Option.none();
    private final ClassByteArraySource classByteSource;

    public JarCreatingJarFinder(ClassByteArraySource classByteSource) {
        this.classByteSource = classByteSource;
    }

    public JarCreatingJarFinder() {
        this((ClassByteArraySource)new ClassPathByteArraySource());
    }

    @Override
    public Option<String> getJarLocation() {
        if (this.location.hasNone()) {
            this.location = this.createJar();
        }
        return this.location;
    }

    private Option<String> createJar() {
        try {
            File randomName = File.createTempFile(FileUtil.randomFilename(), ".jar");
            FileOutputStream fos = new FileOutputStream(randomName);
            this.createJarFromClassPathResources(fos, randomName.getAbsolutePath());
            return Option.some((Object)randomName.getAbsolutePath());
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException((Throwable)ex);
        }
    }

    private void createJarFromClassPathResources(FileOutputStream fos, String location) throws IOException {
        Manifest m = new Manifest();
        m.clear();
        Attributes global = m.getMainAttributes();
        if (global.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            global.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        File mylocation = new File(location);
        global.putValue(BOOT_CLASSPATH, this.getBootClassPath(mylocation));
        global.putValue(PREMAIN_CLASS, AGENT_CLASS_NAME);
        global.putValue(CAN_REDEFINE_CLASSES, "true");
        global.putValue(CAN_SET_NATIVE_METHOD, "true");
        JarOutputStream jos = new JarOutputStream((OutputStream)fos, m);
        this.addClass(HotSwapAgent.class, jos);
        this.addClass(CodeCoverageStore.class, jos);
        this.addClass(InvokeReceiver.class, jos);
        jos.close();
    }

    private String getBootClassPath(File mylocation) {
        return mylocation.getAbsolutePath().replace('\\', '/');
    }

    private void addClass(Class<?> clazz, JarOutputStream jos) throws IOException {
        String className = clazz.getName();
        ZipEntry ze = new ZipEntry(className.replace(".", "/") + ".class");
        jos.putNextEntry(ze);
        jos.write(this.classBytes(className));
        jos.closeEntry();
    }

    private byte[] classBytes(String className) {
        Option bytes = this.classByteSource.getBytes(className);
        if (bytes.hasSome()) {
            return (byte[])bytes.value();
        }
        throw new PitError("Unable to load class content for " + className);
    }

    @Override
    public void close() {
        if (this.location.hasSome()) {
            File f = new File((String)this.location.value());
            f.delete();
        }
    }
}

