/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.incremental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.TestInfo;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationAnalyser;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.incremental.CodeHistory;
import org.pitest.util.Log;

public class IncrementalAnalyser
implements MutationAnalyser {
    private static final Logger LOG = Log.getLogger();
    private final CodeHistory history;
    private final CoverageDatabase coverage;
    private final Map<DetectionStatus, Long> preAnalysed = IncrementalAnalyser.createStatusMap();

    public IncrementalAnalyser(CodeHistory history, CoverageDatabase coverage) {
        this.history = history;
        this.coverage = coverage;
    }

    private static Map<DetectionStatus, Long> createStatusMap() {
        EnumMap<DetectionStatus, Long> map = new EnumMap<DetectionStatus, Long>(DetectionStatus.class);
        for (DetectionStatus each : DetectionStatus.values()) {
            map.put(each, 0L);
        }
        return map;
    }

    @Override
    public Collection<MutationResult> analyse(Collection<MutationDetails> mutation) {
        ArrayList<MutationResult> mrs = new ArrayList<MutationResult>(mutation.size());
        for (MutationDetails each : mutation) {
            Option<MutationStatusTestPair> maybeResult = this.history.getPreviousResult(each.getId());
            if (maybeResult.hasNone()) {
                mrs.add(this.analyseFromScratch(each));
                continue;
            }
            mrs.add(this.analyseFromHistory(each, (MutationStatusTestPair)maybeResult.value()));
        }
        this.logTotals();
        return mrs;
    }

    private void logTotals() {
        for (Map.Entry<DetectionStatus, Long> each : this.preAnalysed.entrySet()) {
            if (each.getValue() == 0L) continue;
            LOG.fine("Incremental analysis set " + each.getValue() + " mutations to a status of " + each.getKey());
        }
    }

    private MutationResult analyseFromHistory(MutationDetails each, MutationStatusTestPair mutationStatusTestPair) {
        ClassName clazz = each.getClassName();
        if (this.history.hasClassChanged(clazz)) {
            return this.analyseFromScratch(each);
        }
        if (mutationStatusTestPair.getStatus() == DetectionStatus.TIMED_OUT) {
            return this.makeResult(each, DetectionStatus.TIMED_OUT);
        }
        if (mutationStatusTestPair.getStatus() == DetectionStatus.KILLED && this.killingTestHasNotChanged(each, mutationStatusTestPair)) {
            return this.makeResult(each, DetectionStatus.KILLED, (String)mutationStatusTestPair.getKillingTest().value());
        }
        if (mutationStatusTestPair.getStatus() == DetectionStatus.SURVIVED && !this.history.hasCoverageChanged(clazz, this.coverage.getCoverageIdForClass(clazz))) {
            return this.makeResult(each, DetectionStatus.SURVIVED);
        }
        return this.analyseFromScratch(each);
    }

    private boolean killingTestHasNotChanged(MutationDetails each, MutationStatusTestPair mutationStatusTestPair) {
        Collection<TestInfo> allTests = this.coverage.getTestsForClass(each.getClassName());
        List testClasses = FCollection.filter(allTests, IncrementalAnalyser.testIsCalled((String)mutationStatusTestPair.getKillingTest().value())).map(TestInfo.toDefiningClassName());
        if (testClasses.isEmpty()) {
            return false;
        }
        return !this.history.hasClassChanged((ClassName)testClasses.get(0));
    }

    private static F<TestInfo, Boolean> testIsCalled(final String testName) {
        return new F<TestInfo, Boolean>(){

            public Boolean apply(TestInfo a) {
                return a.getName().equals(testName);
            }
        };
    }

    private MutationResult analyseFromScratch(MutationDetails mutation) {
        return this.makeResult(mutation, DetectionStatus.NOT_STARTED);
    }

    private MutationResult makeResult(MutationDetails each, DetectionStatus status) {
        return this.makeResult(each, status, null);
    }

    private MutationResult makeResult(MutationDetails each, DetectionStatus status, String killingTest) {
        this.updatePreanalysedTotal(status);
        return new MutationResult(each, new MutationStatusTestPair(0, status, killingTest));
    }

    private void updatePreanalysedTotal(DetectionStatus status) {
        if (status != DetectionStatus.NOT_STARTED) {
            long count = this.preAnalysed.get(status);
            this.preAnalysed.put(status, count + 1L);
        }
    }
}

