/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.io.Serializable;

public enum ConfigOption {
    REPORT_DIR("reportDir"),
    TARGET_CLASSES("targetClasses"),
    SOURCE_DIR("sourceDirs"),
    MUTATIONS("mutators"),
    DEPENDENCY_DISTANCE("dependencyDistance", Integer.valueOf(-1)),
    CHILD_JVM("jvmArgs"),
    MUTATE_STATIC_INITIALIZERS("mutateStaticInits", Boolean.valueOf(false)),
    TIME_STAMPED_REPORTS("timestampedReports", Boolean.valueOf(true)),
    THREADS("threads", Integer.valueOf(1)),
    TIMEOUT_FACTOR("timeoutFactor", Float.valueOf(1.25f)),
    TIMEOUT_CONST("timeoutConst", Long.valueOf(4000L)),
    TEST_FILTER("targetTests"),
    AVOID_CALLS("avoidCallsTo"),
    EXCLUDED_METHOD("excludedMethods"),
    MAX_MUTATIONS_PER_CLASS("maxMutationsPerClass", Integer.valueOf(0)),
    VERBOSE("verbose", Boolean.valueOf(false)),
    EXCLUDED_CLASSES("excludedClasses"),
    OUTPUT_FORMATS("outputFormats"),
    CLASSPATH("classPath"),
    CLASSPATH_FILE("classPathFile"),
    FAIL_WHEN_NOT_MUTATIONS("failWhenNoMutations", Boolean.valueOf(true)),
    CODE_PATHS("mutableCodePaths"),
    INCLUDED_GROUPS("includedGroups"),
    EXCLUDED_GROUPS("excludedGroups"),
    MUTATION_UNIT_SIZE("mutationUnitSize", Integer.valueOf(0)),
    USE_INLINED_CODE_DETECTION("detectInlinedCode", Boolean.valueOf(true)),
    HISTORY_INPUT_LOCATION("historyInputLocation"),
    HISTORY_OUTPUT_LOCATION("historyOutputLocation"),
    MUTATION_THRESHOLD("mutationThreshold", Integer.valueOf(0)),
    MAX_SURVIVING("maxSurviving", Integer.valueOf(-1)),
    COVERAGE_THRESHOLD("coverageThreshold", Integer.valueOf(0)),
    MUTATION_ENGINE("mutationEngine", (Serializable)((Object)"gregor")),
    EXPORT_LINE_COVERAGE("exportLineCoverage", Boolean.valueOf(false)),
    INCLUDE_LAUNCH_CLASSPATH("includeLaunchClasspath", Boolean.valueOf(true)),
    JVM_PATH("jvmPath"),
    PLUGIN_CONFIGURATION("pluginConfiguration");

    private final String text;
    private final Serializable defaultValue;

    private ConfigOption(String text) {
        this(text, null);
    }

    private ConfigOption(String text, Serializable defaultValue) {
        this.text = text;
        this.defaultValue = defaultValue;
    }

    public String getParamName() {
        return this.text;
    }

    public <T> T getDefault(Class<T> type) {
        return (T)this.defaultValue;
    }

    public String toString() {
        return this.text;
    }
}

