/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.mutationtest.verify.BuildVerifier;
import org.pitest.util.Log;

class MissingJUnit5PluginVerifier
implements BuildVerifier {
    private final CodeSource code;

    MissingJUnit5PluginVerifier(CodeSource code) {
        this.code = code;
    }

    @Override
    public List<String> verify() {
        if (!this.junit5PluginIsPresent() && this.junitJupiterPresent()) {
            String msg = "JUnit 5 is on the classpath but the pitest junit 5 plugin is not installed (https://github.com/pitest/pitest-junit5-plugin)";
            Log.getLogger().warning(msg);
            return Arrays.asList(msg);
        }
        return Collections.emptyList();
    }

    private boolean junitJupiterPresent() {
        return this.code.fetchClassBytes(ClassName.fromString((String)"org.junit.jupiter.api.Test")).isPresent();
    }

    private boolean junit5PluginIsPresent() {
        return this.code.fetchClassBytes(ClassName.fromString((String)"org.pitest.junit5.JUnit5TestPluginFactory")).isPresent();
    }
}

