/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal;

import java.util.Date;
import java.util.List;
import javax.enterprise.inject.Typed;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.IdentityQueryBuilder;

@Typed(value={SecuredIdentityManager.class})
public class SecuredIdentityManager
implements IdentityManager {
    private static final long serialVersionUID = -8197103563768366958L;
    private IdentityManager decorated;

    public SecuredIdentityManager(IdentityManager decorated) {
        this.decorated = decorated;
    }

    public void add(IdentityType identityType) throws IdentityManagementException {
        this.decorated.add(identityType);
    }

    public void update(IdentityType identityType) throws IdentityManagementException {
        this.decorated.update(identityType);
    }

    public void remove(IdentityType value) throws IdentityManagementException {
        this.decorated.remove(value);
    }

    public <T extends IdentityType> T lookupIdentityById(Class<T> identityType, String id) {
        return (T)this.decorated.lookupIdentityById(identityType, id);
    }

    public <T extends IdentityType> IdentityQuery<T> createIdentityQuery(Class<T> identityType) {
        return this.decorated.createIdentityQuery(identityType);
    }

    public void validateCredentials(Credentials credentials) {
        this.decorated.validateCredentials(credentials);
    }

    public void updateCredential(Account account, Object credential) {
        this.decorated.updateCredential(account, credential);
    }

    public void updateCredential(Account account, Object credential, Date effectiveDate, Date expiryDate) {
        this.decorated.updateCredential(account, credential, effectiveDate, expiryDate);
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Account account, Class<T> storageClass) {
        return (T)this.decorated.retrieveCurrentCredential(account, storageClass);
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Account account, Class<T> storageClass) {
        return this.decorated.retrieveCredentials(account, storageClass);
    }

    public void removeCredential(Account account, Class<? extends CredentialStorage> storageClass) {
        this.decorated.removeCredential(account, storageClass);
    }

    public IdentityQueryBuilder getQueryBuilder() {
        return this.decorated.getQueryBuilder();
    }
}

