/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.stormpath.credentials.authenticator;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.UsernamePasswordRequest;
import com.stormpath.sdk.client.ApiKey;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.client.DefaultApiKey;
import com.stormpath.sdk.resource.ResourceException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.BadCredentialsException;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.stormpath.profile.StormpathProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormpathAuthenticator
extends ProfileDefinitionAware<StormpathProfile>
implements Authenticator<UsernamePasswordCredentials> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Application application;
    private String accessId;
    private String secretKey;
    private String applicationId;

    public StormpathAuthenticator() {
    }

    public StormpathAuthenticator(String accessId, String secretKey, String applicationId) {
        this.accessId = accessId;
        this.secretKey = secretKey;
        this.applicationId = applicationId;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"accessId", (String)this.accessId);
        CommonHelper.assertNotBlank((String)"secretKey", (String)this.secretKey);
        CommonHelper.assertNotBlank((String)"applicationId", (String)this.applicationId);
        try {
            Client client = new Client((ApiKey)new DefaultApiKey(this.accessId, this.secretKey));
            this.application = (Application)client.getDataStore().getResource(String.format("/applications/%s", this.applicationId), Application.class);
        }
        catch (Exception e) {
            throw new TechnicalException("An exception is caught trying to access Stormpath cloud. Please verify that your provided Stormpath <accessId>, <secretKey>, and <applicationId> are correct.", (Throwable)e);
        }
        this.defaultProfileDefinition((ProfileDefinition)new CommonProfileDefinition(x -> new StormpathProfile()));
    }

    public void validate(UsernamePasswordCredentials credentials, WebContext context) throws HttpAction, CredentialsException {
        this.init(context);
        try {
            this.logger.debug("Attempting to authenticate user [{}] against application [{}] in Stormpath cloud...", (Object)credentials.getUsername(), (Object)this.application.getName());
            Account account = this.authenticateAccount(credentials);
            this.logger.debug("Successfully authenticated user [{}]", (Object)account.getUsername());
            StormpathProfile profile = this.createProfile(account);
            credentials.setUserProfile((CommonProfile)profile);
        }
        catch (ResourceException e) {
            throw new BadCredentialsException("Bad credentials for: " + credentials.getUsername(), (Throwable)e);
        }
    }

    protected Account authenticateAccount(UsernamePasswordCredentials credentials) throws ResourceException {
        return this.application.authenticateAccount((AuthenticationRequest)new UsernamePasswordRequest(credentials.getUsername(), credentials.getPassword())).getAccount();
    }

    protected StormpathProfile createProfile(Account account) {
        StormpathProfile profile = (StormpathProfile)this.getProfileDefinition().newProfile(new Object[0]);
        profile.setId(account.getUsername());
        this.getProfileDefinition().convertAndAdd((CommonProfile)profile, "fullName", (Object)account.getFullName());
        this.getProfileDefinition().convertAndAdd((CommonProfile)profile, "email", (Object)account.getEmail());
        this.getProfileDefinition().convertAndAdd((CommonProfile)profile, "givenName", (Object)account.getGivenName());
        this.getProfileDefinition().convertAndAdd((CommonProfile)profile, "middleName", (Object)account.getMiddleName());
        this.getProfileDefinition().convertAndAdd((CommonProfile)profile, "surName", (Object)account.getSurname());
        this.getProfileDefinition().convertAndAdd((CommonProfile)profile, "groups", (Object)account.getGroups());
        this.getProfileDefinition().convertAndAdd((CommonProfile)profile, "groupMemberships", (Object)account.getGroupMemberships());
        this.getProfileDefinition().convertAndAdd((CommonProfile)profile, "status", (Object)account.getStatus());
        return profile;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }
}

