/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.IndexedJoinBiNode;
import org.optaplanner.constraint.streams.bavet.bi.UnindexedJoinBiNode;
import org.optaplanner.constraint.streams.bavet.common.AbstractJoinNode;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.common.index.JoinerUtils;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.constraint.streams.common.bi.DefaultBiJoiner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetJoinBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetJoinBridgeUniConstraintStream<Solution_, A> leftParent;
    private final BavetJoinBridgeUniConstraintStream<Solution_, B> rightParent;
    private final DefaultBiJoiner<A, B> joiner;
    private final BiPredicate<A, B> filtering;

    public BavetJoinBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetJoinBridgeUniConstraintStream<Solution_, A> leftParent, BavetJoinBridgeUniConstraintStream<Solution_, B> rightParent, DefaultBiJoiner<A, B> joiner, BiPredicate<A, B> filtering) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int outputStoreSize = buildHelper.extractTupleStoreSize((ConstraintStream)this);
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory((AbstractJoiner)this.joiner);
        AbstractJoinNode node = indexerFactory.hasJoiners() ? new IndexedJoinBiNode(JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), buildHelper.reserveTupleStoreIndex((ConstraintStream)this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex((ConstraintStream)this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex((ConstraintStream)this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex((ConstraintStream)this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex((ConstraintStream)this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex((ConstraintStream)this.rightParent.getTupleSource()), downstream, this.filtering, outputStoreSize + 2, outputStoreSize, outputStoreSize + 1, indexerFactory.buildIndexer(true), indexerFactory.buildIndexer(false)) : new UnindexedJoinBiNode(buildHelper.reserveTupleStoreIndex((ConstraintStream)this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex((ConstraintStream)this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex((ConstraintStream)this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex((ConstraintStream)this.rightParent.getTupleSource()), downstream, this.filtering, outputStoreSize + 2, outputStoreSize, outputStoreSize + 1);
        buildHelper.addNode(node, (ConstraintStream)this.leftParent, (ConstraintStream)this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetJoinBiConstraintStream other = (BavetJoinBiConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent()) && Objects.equals(this.joiner, other.joiner) && Objects.equals(this.filtering, other.filtering);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.leftParent.getParent(), this.rightParent.getParent(), this.joiner, this.filtering});
    }

    public String toString() {
        return "BiJoin() with " + this.childStreamList.size() + " children";
    }
}

