/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal.spi;

import org.apache.log4j.Level;
import org.ops4j.pax.logging.spi.PaxLevel;

public class PaxLevelImpl
implements PaxLevel {
    private Level m_delegate;

    public PaxLevelImpl(Level delegate) {
        this.m_delegate = delegate;
    }

    public boolean isGreaterOrEqual(PaxLevel r) {
        if (r instanceof PaxLevelImpl) {
            PaxLevelImpl impl = (PaxLevelImpl)r;
            return this.m_delegate.isGreaterOrEqual(impl.m_delegate);
        }
        return this.getSyslogEquivalent() <= r.getSyslogEquivalent();
    }

    public int toInt() {
        if (this.m_delegate.isGreaterOrEqual(Level.ERROR)) {
            return 4;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.WARN)) {
            return 3;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.INFO)) {
            return 2;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.DEBUG)) {
            return 1;
        }
        return 0;
    }

    public int getSyslogEquivalent() {
        return this.m_delegate.getSyslogEquivalent();
    }

    public String toString() {
        return this.m_delegate.toString();
    }
}

