/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.mssql.impl;

import com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerXADataSource;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;

public class MSSQLDataSourceFactory
implements DataSourceFactory {
    public DataSource createDataSource(Properties props) throws SQLException {
        SQLServerDataSource ds = new SQLServerDataSource();
        return (DataSource)this.setProperties(ds, props);
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        SQLServerConnectionPoolDataSource ds = new SQLServerConnectionPoolDataSource();
        return (ConnectionPoolDataSource)this.setProperties((SQLServerDataSource)ds, props);
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        SQLServerXADataSource ds = new SQLServerXADataSource();
        return (XADataSource)this.setProperties((SQLServerDataSource)ds, props);
    }

    public Driver createDriver(Properties props) throws SQLException {
        return new SQLServerDriver();
    }

    private <T> T setProperties(SQLServerDataSource ds, Properties props) {
        String url = (String)props.remove("url");
        ds.setURL(url);
        String databaseName = (String)props.remove("databaseName");
        ds.setDatabaseName(databaseName);
        String serverName = (String)props.remove("serverName");
        ds.setServerName(serverName);
        String portNumber = (String)props.remove("portNumber");
        if (portNumber != null) {
            ds.setPortNumber(Integer.parseInt(portNumber));
        }
        String user = (String)props.remove("user");
        ds.setUser(user);
        String password = (String)props.remove("password");
        ds.setPassword(password);
        if (!props.isEmpty()) {
            BeanConfig.configure((Object)ds, props);
        }
        return (T)ds;
    }
}

