/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import nebula.plugin.publishing.maven.MavenPublishPlugin;
import nebula.plugin.publishing.maven.MavenResolvedDependenciesPlugin;
import nebula.plugin.publishing.maven.MavenShadowPublishPlugin;
import nebula.plugin.publishing.maven.license.MavenApacheLicensePlugin;
import nebula.plugin.publishing.publications.JavadocJarPlugin;
import nebula.plugin.publishing.publications.SourceJarPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RewritePublishPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JavaBasePlugin.class);
        project.getPlugins().apply(SourceJarPlugin.class);
        project.getPlugins().apply(JavadocJarPlugin.class);
        project.getPlugins().apply(SigningPlugin.class);
        project.getPlugins().apply(MavenPublishPlugin.class);
        project.getPlugins().apply(MavenResolvedDependenciesPlugin.class);
        project.getPlugins().apply(MavenApacheLicensePlugin.class);
        project.getPlugins().withId("com.github.johnrengelman.shadow", plugin -> project.getPlugins().apply(MavenShadowPublishPlugin.class));
        project.getTasks().withType(GenerateModuleMetadata.class).configureEach(task -> task.setEnabled(false));
        project.getExtensions().configure(SigningExtension.class, ext -> {
            ext.setRequired(!project.getVersion().toString().endsWith("SNAPSHOT") || project.hasProperty("forceSigning"));
            ext.useInMemoryPgpKeys((String)project.findProperty("signingKey"), (String)project.findProperty("signingPassword"));
            ext.sign(new Publication[]{(Publication)((PublishingExtension)project.getExtensions().getByType(PublishingExtension.class)).getPublications().findByName("nebula")});
        });
        project.getExtensions().configure(PublishingExtension.class, ext -> ext.getPublications().named("nebula", MavenPublication.class, pub -> {
            pub.suppressPomMetadataWarningsFor("runtimeElements");
            pub.pom(pom -> pom.withXml(xml -> {
                Element dependencies = (Element)xml.asElement().getElementsByTagName("dependencies").item(0);
                NodeList dependencyList = dependencies.getElementsByTagName("dependency");
                int length = dependencyList.getLength();
                for (int i = 0; i < length; ++i) {
                    Node dependency = dependencyList.item(i);
                    if (dependency.getNodeType() != 1) continue;
                    Element dependencyElement = (Element)dependency;
                    Node scope = ((Element)dependency).getElementsByTagName("scope").item(0);
                    if (scope == null || !scope.getTextContent().equals("provided") && !dependencyElement.getElementsByTagName("groupId").item(0).getTextContent().equals("org.projectlombok")) continue;
                    dependencies.removeChild(dependency);
                    --i;
                    --length;
                }
            }));
        }));
    }
}

