/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import nebula.plugin.publishing.maven.MavenBasePublishPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPom;
import org.gradle.jvm.tasks.Jar;
import org.openrewrite.internal.lang.Nullable;

public class ModerneProprietaryLicensePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        Jar emptySourcesJar;
        Task sourcesJar = (Task)project.getTasks().findByName("sourcesJar");
        if (sourcesJar != null) {
            sourcesJar.setEnabled(false);
            emptySourcesJar = (Jar)project.getTasks().create("emptySourceJar", Jar.class, task -> {
                task.from(new Object[]{"README.md"});
                task.getArchiveClassifier().set((Object)"sources");
            });
            project.getTasks().named("assemble", task -> task.dependsOn(new Object[]{emptySourcesJar}));
        } else {
            emptySourcesJar = null;
        }
        project.getPlugins().apply(MavenBasePublishPlugin.class);
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        publishing.publications(publications -> publications.withType(MavenPublication.class, p -> this.configureLicense((MavenPublication)p, emptySourcesJar)));
    }

    private void configureLicense(MavenPublication publication, @Nullable Jar sourcesJar) {
        if (sourcesJar != null) {
            publication.artifact((Object)sourcesJar);
        }
        publication.pom(pom -> pom.licenses(licenses -> licenses.license(license -> {
            ((DefaultMavenPom)licenses).getLicenses().clear();
            license.getName().set((Object)"Moderne Proprietary License");
            license.getUrl().set((Object)"https://docs.moderne.io/licensing/overview");
        })));
    }
}

