/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.internal.service.ServiceRegistry;
import org.jspecify.annotations.Nullable;
import org.openrewrite.gradle.GradleProjectParser;
import org.openrewrite.gradle.RewriteClassLoader;
import org.openrewrite.gradle.RewriteExtension;

public class DelegatingProjectParser
implements GradleProjectParser {
    protected static @Nullable List<URL> rewriteClasspath;
    protected static @Nullable RewriteClassLoader rewriteClassLoader;
    protected final GradleProjectParser gpp;

    public DelegatingProjectParser(Project project, RewriteExtension extension, Set<Path> classpath) {
        try {
            List<URL> classpathUrls = classpath.stream().map(Path::toUri).map(uri -> {
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            URL currentJar = this.jarContainingResource(this.getClass().getResource("/org/openrewrite/gradle/isolated/DefaultProjectParser.class").toString());
            classpathUrls.add(currentJar);
            ClassLoader pluginClassLoader = this.getPluginClassLoader(project);
            if (rewriteClassLoader == null || !classpathUrls.equals(rewriteClasspath) || rewriteClassLoader.getPluginClassLoader() != pluginClassLoader) {
                if (rewriteClassLoader != null) {
                    rewriteClassLoader.close();
                }
                rewriteClassLoader = new RewriteClassLoader(classpathUrls, pluginClassLoader);
                rewriteClasspath = classpathUrls;
            }
            Class<?> gppClass = Class.forName("org.openrewrite.gradle.isolated.DefaultProjectParser", true, rewriteClassLoader);
            assert (gppClass.getClassLoader() == rewriteClassLoader) : "DefaultProjectParser must be loaded from RewriteClassLoader to be sufficiently isolated from Gradle's classpath";
            this.gpp = (GradleProjectParser)gppClass.getDeclaredConstructor(Project.class, RewriteExtension.class).newInstance(project, extension);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getActiveRecipes() {
        return this.unwrapInvocationException(this.gpp::getActiveRecipes);
    }

    @Override
    public List<String> getActiveStyles() {
        return this.unwrapInvocationException(this.gpp::getActiveStyles);
    }

    @Override
    public List<String> getAvailableStyles() {
        return this.unwrapInvocationException(this.gpp::getAvailableStyles);
    }

    @Override
    public void discoverRecipes(ServiceRegistry serviceRegistry) {
        this.unwrapInvocationException(() -> {
            this.gpp.discoverRecipes(serviceRegistry);
            return null;
        });
    }

    @Override
    public Collection<Path> listSources() {
        return this.unwrapInvocationException(this.gpp::listSources);
    }

    @Override
    public void run(Consumer<Throwable> onError) {
        this.unwrapInvocationException(() -> {
            this.gpp.run(onError);
            return null;
        });
    }

    @Override
    public void dryRun(Path reportPath, boolean dumpGcActivity, Consumer<Throwable> onError) {
        this.unwrapInvocationException(() -> {
            this.gpp.dryRun(reportPath, dumpGcActivity, onError);
            return null;
        });
    }

    @Override
    public void shutdownRewrite() {
        this.unwrapInvocationException(() -> {
            this.gpp.shutdownRewrite();
            return null;
        });
    }

    protected URL jarContainingResource(String resourcePath) {
        try {
            if (resourcePath.startsWith("jar:")) {
                int indexOfBang = (resourcePath = resourcePath.substring(4)).indexOf("!");
                if (indexOfBang != -1) {
                    resourcePath = resourcePath.substring(0, indexOfBang);
                }
                return new URI(resourcePath).toURL();
            }
            if (resourcePath.startsWith("file:")) {
                return new URI(resourcePath.substring(0, resourcePath.lastIndexOf("/main/") + 6)).toURL();
            }
            return Paths.get(System.getProperty("jarLocationForTest"), new String[0]).toUri().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T unwrapInvocationException(Callable<T> supplier) {
        try {
            return supplier.call();
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader getPluginClassLoader(Project project) {
        ClassLoader pluginClassLoader = this.getAndroidPluginClassLoader(project);
        if (pluginClassLoader == null) {
            pluginClassLoader = this.getClass().getClassLoader();
        }
        return pluginClassLoader;
    }

    private @Nullable ClassLoader getAndroidPluginClassLoader(Project project) {
        List<String> pluginIds = Arrays.asList("com.android.application", "com.android.library", "com.android.feature", "com.android.dynamic-feature", "com.android.test");
        for (String pluginId : pluginIds) {
            if (!project.getPlugins().hasPlugin(pluginId)) continue;
            Plugin plugin = project.getPlugins().getPlugin(pluginId);
            return plugin.getClass().getClassLoader();
        }
        return null;
    }
}

